/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef UNIX_SEMAPHORE_H
#define UNIX_SEMAPHORE_H
#include <portablethreads/unix/config.h>
#include <fcntl.h> 
#include <sys/types.h>
#include <semaphore.h>
#include <errno.h>

PT_NAMESPACE_BEGIN
class PSemaphore : public PWaitable
{
public:
	static const unsigned MAX = SEM_VALUE_MAX;
	PSemaphore(unsigned initially = 0)
	{
		while(sem_init(&sem_, 0, initially > MAX ? MAX : initially) < 0);
	}
  	
	// WARNING: make sure there is no thread waiting on the semaphore
	// because doing so will result in undefined behavior when the
	// semaphore is destroyed
	~PSemaphore()
	{
		while(sem_destroy(&sem_) < 0);
	}
	
	inline bool tryDown()
  	{
		// I don't really care why it failed...
		return sem_trywait(&sem_) == 0;
    }
    
	inline void down()
  	{
    	while(sem_wait(&sem_) == -1 && errno == EINTR);
    }
    
	inline void up()
  	{
  		// ok, only error as of POSIX is "invalid sem"
    	sem_post(&sem_);
  	}		
	inline operator sem_t*() { return &sem_; }
	bool queryState() { return tryDown(); }
private:
	// Semaphores cannot be copied or assigned
	PSemaphore(const PSemaphore&);
  	PSemaphore& operator=(const PSemaphore&);
private:
	sem_t sem_;
};
PT_NAMESPACE_END

#endif
