/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef UNIX_THREAD_H
#define UNIX_THREAD_H
#include <portablethreads/unix/config.h>

PT_NAMESPACE_BEGIN
// see above
class PThread : public PThreadBase
{
	pthread_t thread_;
	
	static void* threadEntry(void* arg);
	
	virtual void threadImpl() = 0;
	virtual void unexpectedException() throw();
	PThread(const PThread&);
	PThread& operator=(const PThread&);	
public:
	typedef unsigned long thread_type;
	static inline thread_type self()
	{
		return reinterpret_cast<thread_type>(pthread_self());
	}
public:	
	PThread()	
	{}
    
    virtual ~PThread();

	
	inline bool run()
	{
		return pthread_create(&thread_, 0, &threadEntry, this) == 0;
	}
	inline void stop()
	{
		pthread_cancel(thread_);			
	}
	inline bool join()
	{
		if(joinable_)
			pthread_join(thread_, 0);
		return joinable_;
	}
	inline void give()
	{
		sched_yield();
	}
	inline void detach()
	{
		joinable_ = false;
		pthread_detach(thread_); 
	}
	
	inline bool operator==(const PThread& o) const
	{
		if(&o == this)
			return true;
			
		return pthread_equal(thread_, o.thread_) != 0;
	}
	
	inline bool operator!=(const PThread& o) const
	{
		return !(*this == o);
	}
	bool queryState() { return join(); }	
};
PT_NAMESPACE_END

#endif
