/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#include <portablethreads/unix/config.h>
#include <sys/time.h>
#include <unistd.h>
#include <sched.h>

PT_NAMESPACE_BEGIN
void pt_second_sleep(unsigned time)
{
	sleep(time);
}
void pt_milli_sleep(unsigned time)
{
	usleep(time*1000);
}
void pt_micro_sleep(unsigned time)
{
	usleep(time); 
}
void pt_yield()
{
	sched_yield();
}

///////////////////////////////////////////////////////////////////////
// Time
///////////////////////////////////////////////////////////////////////

uint64 PTime::stamp() const
{
	timeval tv;
	gettimeofday(&tv, 0);
	
	uint64 t = tv.tv_usec;
	t += tv.tv_sec*1000000;
	return t;
}

uint64 PTime::calculateFrequency()
{
	return 1000000;
}
const uint64 PTime::frequency_ = PTime::calculateFrequency();

PT_NAMESPACE_END
