// $Id: test_constraint_injector.cpp 1679 2005-04-03 17:45:56Z jean $

#include <iostream>
#include <string>
#include <sstream>
#include <algorithm>
#include <fstream>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <test/program_metadata.h>
#include <platypus/types.h>
#include <platypus/types/inject_constraints.h>


using namespace std;
using namespace Platypus;

class ConstraintInjectorTest : public CppUnit::TestFixture
{
	ProgramMetaData* metaData_;
	typedef ProgramInterface ProgramType;
	Platypus::Atom getAtom(PartialAssignment& pm, const std::string& name)
	{
		for(PartialAssignment::CollectionType::const_iterator it = pm.unknownAtoms().begin();
			it != pm.unknownAtoms().end(); ++it)
		{
			if(it->name() == name)
				return *it;
		}

		for(PartialAssignment::CollectionType::const_iterator it = pm.positiveAtoms().begin();
			it != pm.positiveAtoms().end(); ++it)
		{
			if(it->name() == name)
				return *it;
		}

		for(PartialAssignment::CollectionType::const_iterator it = pm.negativeAtoms().begin();
			it != pm.negativeAtoms().end(); ++it)
		{
			if(it->name() == name)
				return *it;
		}
		throw 1;
	}
public:
	ConstraintInjectorTest()
	{
		ifstream in("metadata.txt");
		CPPUNIT_ASSERT(in);
		metaData_ = new ProgramMetaData(in);
	}
	~ConstraintInjectorTest()
	{
		delete metaData_;
	}
	
	void testEmpty()
	{
		Program program;
		program.setup(EMPTY_PROGRAM);
		
		
		DelegatableChoice dc;
		{
			InjectConstraints injector(dc, program);
			stringstream s;
			s << injector.stream().rdbuf();
			CPPUNIT_ASSERT_EQUAL(s.str(), string(EMPTY_PROGRAM));
		}
	}
	
	void testWithoutConstraint()
	{
		ifstream in("usualcases.lparse");
		CPPUNIT_ASSERT(in);
		Program program;
		program.setup(in);
		
		PartialAssignment pm(program);
		

		
		{
			DelegatableChoice dc;
			dc.push_back(Choice(getAtom(pm, "i").id(), true));
			InjectConstraints injector(dc, program);
			stringstream s1, s2;
			s1 << injector.stream().rdbuf();
			ifstream in("usualcases-i-true.lparse");
			CPPUNIT_ASSERT(in);
			s2 << in.rdbuf();
			CPPUNIT_ASSERT_EQUAL(s1.str(), s2.str());
		}
		{
			DelegatableChoice dc;
			dc.push_back(Choice(getAtom(pm, "i").id(), false));
			InjectConstraints injector(dc, program);
			stringstream s1, s2;
			s1 << injector.stream().rdbuf();
			ifstream in("usualcases-i-false.lparse");
			CPPUNIT_ASSERT(in);
			s2 << in.rdbuf();
			CPPUNIT_ASSERT_EQUAL(s1.str(), s2.str());
		}

	}
	void testWithOneTrue()
	{
		ifstream in("usualcases-i-true.lparse");
		CPPUNIT_ASSERT(in);
		Program program;
		program.setup(in);
		PartialAssignment pm(program);
		
		{
			DelegatableChoice dc;
			dc.push_back(Choice(getAtom(pm, "i").id(), false));

			InjectConstraints injector(dc, program);
			stringstream s1, s2;
			s1 << injector.stream().rdbuf();
			ifstream in("usualcases-i-both.lparse");
			CPPUNIT_ASSERT(in);
			s2 << in.rdbuf();
			CPPUNIT_ASSERT_EQUAL(s1.str(), s2.str());
		}

	}
	void testWithOneFalse()
	{
		ifstream in("usualcases-i-false.lparse");
		CPPUNIT_ASSERT(in);
		Program program;
		program.setup(in);
		
		PartialAssignment pm(program);
		{
			DelegatableChoice dc;
			dc.push_back(Choice(getAtom(pm, "i").id(), true));


			InjectConstraints injector(dc, program);
			stringstream s1, s2;
			s1 << injector.stream().rdbuf();
			ifstream in("usualcases-i-both.lparse");
			CPPUNIT_ASSERT(in);
			s2 << in.rdbuf();
			CPPUNIT_ASSERT_EQUAL(s1.str(), s2.str());
			
		}
		

	}
	CPPUNIT_TEST_SUITE( ConstraintInjectorTest );
		CPPUNIT_TEST( testEmpty );
		CPPUNIT_TEST( testWithoutConstraint );
		CPPUNIT_TEST( testWithOneTrue );
		CPPUNIT_TEST( testWithOneFalse );
		
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( ConstraintInjectorTest );


