/*	$Id: main.cpp 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
 

#include <iostream>
#include <memory>
#include <stdexcept>
#include <platypus/platypus.h>

using namespace std;
using namespace Platypus;

int main(int argc, char** argv)
{
	PlatypusBuilder::registerFactories();
	PlatypusBuilder builder;
	try
	{
		auto_ptr<PlatypusAlgorithm> platypus(builder.build(argc, argv));
		if(!platypus.get())
		{
			cout << builder.usage() << endl;
			return 1;
		}

		// if there is a signal catch it, 
		// disable further signals and 
		// call shutdown on platypus object
		Platypus::notifyOnSignal(*platypus);

		platypus->run();
		cout << *platypus << endl;
	}
	catch(const CommandlineError& e)
	{
		cerr << e.what() << "\n\n" << builder.usage() << "\n";
		return 1;
	}
	catch(const PlatypusException& e)
	{
		cerr << e.what() << endl;
		return 1;
	}
	catch(const exception& e)
	{
		cerr << e.what() << endl;
		return 1;
	}
	catch(...)
	{
		cerr << "Unknown error, exiting" << endl;
		return 1;
	}
	
	return 0;
}







