/*	$Id: algorithm.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef ALGORITHM_H
#define ALGORITHM_H

#include <memory>
#include <iosfwd>
#include <platypus/algorithm/time.h>

class NopStream;
namespace Platypus
{
	class DistributionBase;
	class CoreBase;
	class PlatypusOptions;
	class ProgramInterface;
	class PlatypusAlgorithm
	{
	public:
		PlatypusAlgorithm(	std::auto_ptr<NopStream> str, 
							std::auto_ptr<ProgramInterface> program, 
							std::auto_ptr<PlatypusOptions> options, 
							std::auto_ptr<CoreBase> core,
							std::auto_ptr<DistributionBase> distribution);
		void setOutputStream(std::ostream& os);
		void enableDebugPrinting();
		void disableDebugPrinting();
		std::ostream& print(std::ostream& os) const;
		void run();
		void shutdown();
	private:
		PlatypusAlgorithm();
		void openInput();
	private:
		Time time_;
		std::auto_ptr<NopStream> str_;
		std::auto_ptr<ProgramInterface> program_;
		std::auto_ptr<PlatypusOptions> options_;
		std::auto_ptr<CoreBase> core_;
		std::auto_ptr<DistributionBase> distribution_;
	};

	inline std::ostream& operator<<(std::ostream& os, const PlatypusAlgorithm& platypus)
	{
		return platypus.print(os);
	}
}

#endif
