/*	$Id: builder.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PLATYPUS_BUILDER_H
#define PLATYPUS_BUILDER_H

#include <memory>
#include <platypus/builder/options_builder.h>

class NopStream;
namespace Platypus
{
	class PlatypusAlgorithm;
	class PlatypusOptions;
	class CoreBase;
	class DistributionBase;
	class ProgramInterface;
	class PlatypusBuilder
	{
	public:
		~PlatypusBuilder();
		PlatypusBuilder();
		std::string usage() const;
		static void registerFactories();
		
		PlatypusAlgorithm* build(int& argc, char** argv);
		bool good() const;
	private:
		void buildDistribution(int& argc, char** argv);
		void buildCore();
	private:
		PlatypusOptionsBuilder optionsBuilder_;
		std::auto_ptr<NopStream> stream_;
		std::auto_ptr<ProgramInterface> program_;
		std::auto_ptr<PlatypusOptions> options_;
		std::auto_ptr<CoreBase> core_;
		std::auto_ptr<DistributionBase> distribution_;
	};
}

#endif

