/*	$Id: builder_factory_registration.cpp 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <platypus/types_factory.h>
#include <platypus/cores.h>
#include <platypus/types/delegatable_choice_policy.h>
#include <platypus/types/chooser.h>
#include <platypus/types/atom.h>
#include <platypus/smodels_types.h>
#include <platypus/local/local.h>
#include <platypus/builder/builder_factory_registration.h>

namespace Platypus
{
	/***************************************************************/
	/* FactoryRegistrationStrategy                                 */
	/***************************************************************/
	void FactoryRegistrationStrategy::registerWithFactories()
	{
		DCPolicyFactory::add(DC_POLICY_CHOOSE_EARLIEST, ChooseEarliestPolicy::create, "Delegate largest part of the search space");
		DCPolicyFactory::add(DC_POLICY_CHOOSE_RANDOM, ChooseRandomPolicy::create, "Delegate random part of the search space");

		ChoicePolicyFactory::add(CHOICE_POLICY_CHOOSE_FIRST, ChooseFirstUnknown::create, "Backtrack to last choice");
		ChoicePolicyFactory::add(CHOICE_POLICY_CHOOSE_RANDOM, ChooseRandom::create, "Backtrack to a random choice");
		ChoicePolicyFactory::add(CHOICE_POLICY_EXPANDER, ChooseExpander::create, "Let the expander decide what to do");

		ProgramFactory::add(SMODELS_PROGRAM, SmodelsEnhancedProgram::create);
		ExpanderFactory::add(SMODELS_EXPANDER, SmodelsExpander::create, "Use smodels");

		CoreFactory::add(SINGLE_THREADED_CORE, SingleThreadedCore::create, "Single-threaded core");
		CoreFactory::add(MULTI_THREADED_CORE, MultiThreadedCore::create, "Multi-threaded core");

		DistributionFactory::add(LOCAL_DISTRIBUTION, Local::create, "No distribution");

		registerOSSpecificTypes();
	}
}
