/*	$Id: types_factory.cpp 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <memory>
#include <platypus/cores.h>
#include <platypus/types.h>
#include <platypus/smodels_types.h>
#include <platypus/factories/types_factory.h>

using namespace std;

namespace Platypus
{
	/////////////////////////////////////////////////////////////////////////
	// PlatypusTypesFactory
	/////////////////////////////////////////////////////////////////////////
	const PlatypusTypesFactory& PlatypusTypesFactory::instance()
	{
		static PlatypusTypesFactory instance_;
		return instance_;
	}
	
	PlatypusTypesFactory::PlatypusTypesFactory()
		:	dcFactory_()
		,	choiceFactory_()
		,	programFactory_()
		,	expanderFactory_()
		,	coreFactory_()
		,	distributionFactory_()
	{}

	/////////////////////////////////////////////////////////////////////////
	// ChooserPolicyFactory
	/////////////////////////////////////////////////////////////////////////
	ChoicePolicy* ChoicePolicyFactory::create(const std::string& name) const
	{
		choice_policy_create_function* create = resolve(name);
		if(!create)
			throw TypeError("Unknown choice policy: " + name);
		return (*create)();
	}
	

	/////////////////////////////////////////////////////////////////////////
	// DCPolicyFactory
	/////////////////////////////////////////////////////////////////////////
	DCPolicy* DCPolicyFactory::create(const std::string& name) const
	{
		dcpolicy_create_function* create = resolve(name);
		if(!create)
			throw TypeError("Unknown DelegatableChoicePolicy: " + name);
		return (*create)();
	}

	/////////////////////////////////////////////////////////////////////////
	// ProgramFactory
	/////////////////////////////////////////////////////////////////////////
	ProgramInterface* ProgramFactory::create(const std::string& name) const
	{
		program_create_function* create = resolve(name);
		if(!create)
			return new Program();
		return (*create)();
	}
	
	/////////////////////////////////////////////////////////////////////////
	// ExpanderFactory
	/////////////////////////////////////////////////////////////////////////	
	Expander* ExpanderFactory::create(const ProgramInterface& program, const DelegatableChoice& dc, const std::string& name) const
	{
		expander_create_function* create = resolve(name);
		if(!create)
			throw TypeError("Unknown answer set solver: " + name);
		return (*create)(program, dc);
	}
	
	/////////////////////////////////////////////////////////////////////////
	// CoreFactory
	/////////////////////////////////////////////////////////////////////////	
	CoreBase* CoreFactory::create(const std::string& name) const
	{
		core_create_function* create = resolve(name);
		if(!create)
			throw TypeError("Unknown core: " + name);
		return (*create)();
	}
	/////////////////////////////////////////////////////////////////////////
	// DistributionFactory
	/////////////////////////////////////////////////////////////////////////	
	DistributionBase* DistributionFactory::create(const std::string& name) const
	{
		distribution_create_function* create = resolve(name);
		if(!create)
			throw TypeError("Unknown distribution: " + name);
		return (*create)();
	}
}
