/*	$Id: fork.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef FORK_H
#define FORK_H

#include <iosfwd>
#include <cassert>
#include <vector>
#include <ipc/ipc.h>
#include <platypus/types_fwd.h>
#include <platypus/types/choice.h>
#include <platypus/distribution_base.h>

namespace PortableThreads
{
	class PAtomicNumber;
}

class NopStream;
namespace Platypus
{
	const char* const FORK_DISTRIBUTION = "fork";

	class Fork	:	public DistributionBase
	{
	public:
		Fork();
		static DistributionBase* create();
	private: // BuilderDistributionCallback
		void processCommandLine(int& argc, char** argv);
		void program(const ProgramInterface& prog);
		void output(NopStream& str);
		void options(const PlatypusOptions& values);
		void setup();
	private: // CoreCallback
		bool shutdown();	
		bool delegate(const DelegatableChoice& dc);
		bool needDelegatableChoice() const;
		void fileDelegatableChoiceRequest();
		void cancelDelegatableChoiceRequest();
		bool hasDelegatableChoice();		
		DelegatableChoice delegatableChoice();
		void answerSet(const PartialAssignment& pa);
		void incExpanderInitializations(size_t inc = 1);
		void incConflicts(size_t inc = 1);
		void incBacktracks(size_t inc = 1);
		void incAnswerSets(size_t inc = 1);
		int id() const;
		
		void incThreadDelegations(size_t inc = 1);
	private: // PlatypusAlgorithmCallback
		void teardown();
		bool print() const { return father_; }
		void terminate();
		std::ostream& print(std::ostream& os) const;
		const std::string& type() const { return type_; }
		size_t expanderInitializations() const;
		size_t conflicts() const;
		size_t answerSetsFound() const;
		size_t backtracks() const;
		size_t threads() const;
		size_t threadDelegations() const;
	private:
		bool enoughPrinted() const;
		bool enoughAnswerSets() const;
		bool receiveDC();
		void sendDC(const DelegatableChoice& dc);
		void receiveAnswerSets();
		void sendAnswerSet(const PartialAssignment& pa);
		void fatherSetup();
		void childSetup();
		void setupNumbers();
	private:
		typedef IPC::IPCSHMObject<PortableThreads::PAtomicNumber> SharedAtomicNumber;
		typedef std::vector<SharedAtomicNumber> SharedAtomicNumbers;
		inline PortableThreads::PAtomicNumber& processesThatBelieveQueueIsEmpty() { return numbers_[0]; }
		inline const PortableThreads::PAtomicNumber& processesThatBelieveQueueIsEmpty() const { return numbers_[0]; }
		inline PortableThreads::PAtomicNumber& sharedInits() { return numbers_[1]; }
		inline const PortableThreads::PAtomicNumber& sharedInits() const { return numbers_[1]; }
		inline PortableThreads::PAtomicNumber& sharedConflicts() { return numbers_[2]; }
		inline const PortableThreads::PAtomicNumber& sharedConflicts() const { return numbers_[2]; }
		inline PortableThreads::PAtomicNumber& sharedBacktracks() { return numbers_[3]; }
		inline const PortableThreads::PAtomicNumber& sharedBacktracks() const { return numbers_[3]; }
		inline PortableThreads::PAtomicNumber& sharedStableModels() { return numbers_[4]; }
		inline const PortableThreads::PAtomicNumber& sharedStableModels() const { return numbers_[4]; }
		inline PortableThreads::PAtomicNumber& sharedShutdown() { return numbers_[5]; }
		inline const PortableThreads::PAtomicNumber& sharedShutdown() const { return numbers_[5]; }
		inline PortableThreads::PAtomicNumber& sharedDelegations() { return numbers_[6]; }
		inline const PortableThreads::PAtomicNumber& sharedDelegations() const { return numbers_[6]; }
		inline PortableThreads::PAtomicNumber& sharedThreadDelegations() { return numbers_[7]; }
		inline const PortableThreads::PAtomicNumber& sharedThreadDelegations() const { return numbers_[7]; }
	private:
		size_t id_;
		const std::string type_;
		NopStream* os_;
		DelegatableChoice dc_;
		const ProgramInterface* program_;
		size_t processes_, threads_, printedAnswerSets_;
		mutable IPC::IPCMessageQueue branchesToProcess_, answerSets_;
		IPC::IPCSharedMemory shm_;
		SharedAtomicNumbers numbers_;
		size_t requestedAnswerSets_;
		const bool father_;
		bool filedForDC_, thinkQueueIsEmpty_, suppressAnswerSetPrinting_;
		bool hasDC_;
		volatile bool shutdown_;
		
		static const size_t SHMSize;
	};
}

#endif
