/*	$Id: fork_serializer.cpp 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <cstdio>
#include <platypus/types/atom.h>
#include <platypus/types/partial_assignment.h>
#include <platypus/types/choice.h>
#include <platypus/fork/fork_serializer.h>


namespace Platypus
{
	ForkSerializer::ForkSerializer(const ProgramInterface& program)
		:	program_(&program)
	{}
	void ForkSerializer::deserialize(DelegatableChoice& dc, const IPC::IPCMessageBuffer& buffer) const
	{
		assert(buffer.size() >= sizeof(AtomId));
			
		const AtomId* ids = reinterpret_cast<const AtomId*>(buffer.data());
		const AtomId size = ids[0];
		//std::printf("D dc size: %d\n", size);
		// [size, <Atom id, truthvalue>, <...>, ...], all of type AtomId
		assert(buffer.size() >= sizeof(AtomId)*(2*size+1));
		
		dc.clear();
		size_t index = 1;
		for(size_t i = 0; i < size; ++i, index += 2)
		{
			dc.push_back(Choice(ids[index], ids[index+1]));
		}
	}
	void ForkSerializer::serialize(IPC::IPCMessageBuffer& buffer, const DelegatableChoice& dc) const
	{
		// [size, <Atom id, truthvalue>, <...>, ...], all of type AtomId
		const size_t size = dc.size();
		buffer.resize((1+dc.size()*2)*sizeof(AtomId));
		AtomId* ids = reinterpret_cast<AtomId*>(buffer.data());
		ids[0] = static_cast<AtomId>(size);
		
		size_t index = 1;
		for(size_t i = 0; i < size; ++i, index += 2)
		{
			ids[index] = dc[i].id();
			ids[index+1] = dc[i].isPositive();
		}
	}
	
	void ForkSerializer::deserialize(PartialAssignment& pa, const IPC::IPCMessageBuffer& buffer) const
	{
		assert(buffer.size() >= sizeof(AtomId));		
		const AtomId* ids = reinterpret_cast<const AtomId*>(buffer.data());
		const size_t size = static_cast<size_t>(ids[0]);
		assert(buffer.size() >= sizeof(AtomId)*(1+size));
		
		size_t index = 1; pa.reset();
		for(size_t i = 0; i < size; ++i, ++index)
		{
			pa.setTrue(Atom(ids[index], *program_));
		}
	}
	void ForkSerializer::serialize(IPC::IPCMessageBuffer& buffer, const PartialAssignment& pa) const
	{
		const size_t positive = pa.positiveAtoms().size();

		buffer.resize(sizeof(AtomId)*(positive+1));
		AtomId* ids = reinterpret_cast<AtomId*>(buffer.data());
		ids[0] = positive;
		
		size_t index = 1;
		const PartialAssignment::CollectionType::const_iterator END = pa.positiveAtoms().end();
		for(PartialAssignment::CollectionType::const_iterator it = pa.positiveAtoms().begin();
			it != END; ++it, ++index)
		{
			ids[index] = it->id();
		}
	}
}
