/*	$Id: local.cpp 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <iostream>
#include <nop_stream.h>
#include <platypus/types.h>
#include <platypus/options.h>
#include <platypus/local/local.h>

namespace Platypus
{
	Local::Local()
		:	type_(LOCAL_DISTRIBUTION)
		,	os_(0)
		,	branchesToDo_(1)
		,	program_(0)
		,	requestedAnswerSets_(0)
		,	printedAnswerSets_(0)
		,	expanderInits_(0)
		,	conflicts_(0)
		,	stableModels_(0)
		,	backtracks_(0)
		,	threads_(0)
		,	delegations_(0)
		,	shutdown_(false)
		,	suppressAnswerSets_(false)
		,	cannotFullfillRequest_(false)
	{}
	DistributionBase* Local::create()
	{
		return new Local;
	}
	
	void Local::program(const ProgramInterface& prog)
	{
		program_ = &prog;
	}
	
	void Local::output(NopStream& str)
	{
		os_ = &str;
	}
	void Local::options(const PlatypusOptions& values)
	{
		requestedAnswerSets_ = values.requestedAnswerSets();
		threads_ = values.threads();
		suppressAnswerSets_ = values.silent();
	}
	void Local::setup()
	{
	}

	std::ostream& Local::print(std::ostream& os) const
	{
		return os << "\tNot distributed\n";
	}
	void Local::fileDelegatableChoiceRequest() 
	{
		if(branchesToDo_.empty())
			cannotFullfillRequest_ = true;
	}
	void Local::cancelDelegatableChoiceRequest()
	{
		if(cannotFullfillRequest_)
			cannotFullfillRequest_ = false;
	}
	DelegatableChoice Local::delegatableChoice()
	{
		assert(!branchesToDo_.empty());
		const DelegatableChoice dc(branchesToDo_.back());
		branchesToDo_.pop_back();
		return dc;
	}
	bool Local::delegate(const DelegatableChoice& dc)
	{
		branchesToDo_.push_back(dc);
		return true;
	}
	void Local::disableAnswerSetPrinting() { suppressAnswerSets_ = true; }
	void Local::enableAnswerSetPrinting() { suppressAnswerSets_ = false; }
	bool Local::shutdown() { return enoughAnswerSets() || shutdown_ || cannotFullfillRequest_; }
	void Local::answerSet(const PartialAssignment& pa)
	{
		if(!suppressAnswerSets_ && !enoughPrinted())
		{
			++printedAnswerSets_;
			assert(os_);
			// don't use std::copy here b/c of crummy output with invisible atoms
			os_->str() << "Answer: " << static_cast<unsigned>(printedAnswerSets_) << "\nStable Model: ";
			const PartialAssignment::CollectionType::const_iterator END = pa.positiveAtoms().end();
			for(PartialAssignment::CollectionType::const_iterator it = pa.positiveAtoms().begin();
				it != END; ++it)
			{
				if(it->visible())
					os_->str() << *it << ' ';
			}
			os_->str() << "\n";
		}
	}
	bool Local::enoughPrinted() const
	{
		if(requestedAnswerSets_)
			return printedAnswerSets_ == requestedAnswerSets_;
		return false;
	}
	bool Local::enoughAnswerSets() const
	{
		if(requestedAnswerSets_)
			return requestedAnswerSets_ <= stableModels_;
		return false;
	}
}
