/*	$Id: program_base.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PROGRAM_BASE_H
#define PROGRAM_BASE_H

#include <string>
#include <vector>
#include <iosfwd>

namespace Platypus
{
	// Program shall represent the logic program (the set of lines we call rules)
	// in a lparse related way.
	typedef unsigned long AtomId;
	class ProgramInterface
	{
	public:
		typedef std::vector<AtomId> CollectionType;
		virtual ~ProgramInterface() 
		{}
		// deferred initialization from string/file
		virtual void setup(const std::string&) = 0;
		virtual void setup(std::istream& is) = 0;
		// returns the associated name for an atom
		virtual const std::string& idToName(AtomId id) const = 0;
		
		// returns the id associated with an atom name
		// NOTE: 	Names MUST be returned for all atoms, wether
		// 			they have a "name" (like a, p(v4), ...) or not.	
		virtual AtomId nameToId(const std::string& name) const = 0;
		
		// returns the collection of atoms of the logic program
		virtual const CollectionType& atoms() const = 0;
		
		// Returns the definite number of atoms in the logic program.
		// For instance the logic program
		// d :- {c} 1.
		// c.
		//
		// after being preprocessed by lparse contains FOUR atoms.
		virtual size_t numberOfAtoms() const = 0;
		virtual size_t numberOfRules() const = 0;
		
		// returns true if the atom had a name in the original (textual program), false otherwise.
		virtual bool hasDisplayName(AtomId id) const = 0;	
		
		// returns an lparse representation of the preprocessed program.
		virtual const std::string& lparse() const = 0;
	};
};

#endif 

