/*	$Id: choice.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PLATYPUS_CHOICE_H
#define PLATYPUS_CHOICE_H

#include <iosfwd>
#include <vector>

namespace Platypus
{
	typedef unsigned long ChoiceId;
	typedef std::vector<ChoiceId> PossibleChoices;

	class Choice
    {
    public:
		Choice(ChoiceId id, bool positive);
		inline ChoiceId id() const { return id_; }
		inline bool isPositive() const { return positive_; }
		inline void toggle() { positive_ = !positive_; }
	private:
		Choice();
	private:
		ChoiceId id_;
		bool positive_;
    };

	typedef std::vector<Choice> DelegatableChoice;

	// allow to print Choice/DC to ostream
	std::ostream& operator<<(std::ostream& os, const Choice& choice);
	std::ostream& operator<<(std::ostream& os, const DelegatableChoice& dc);

	inline bool operator==(const Choice& lhs, const Choice& rhs)
	{
		return lhs.id() == rhs.id() && lhs.isPositive() == rhs.isPositive();
	}
	
	inline bool operator!=(const Choice& lhs, const Choice& rhs)
	{
		return !(lhs == rhs);
	} 
};



#endif
