/*	$Id: chooser.cpp 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <iterator> // advance
#include <platypus/program_base.h>
#include <platypus/types/chooser.h>
#include <platypus/types/exceptions.h>

using namespace std;

namespace Platypus
{
	///////////////////////////////////////////////////////////
	// ChooseFirstUnknown
	///////////////////////////////////////////////////////////
	ChooseFirstUnknown::ChooseFirstUnknown()
		:	possibleChoices_(0)
	{}
	ChooseFirstUnknown::ChooseFirstUnknown(const PossibleChoices& pc)
		:	possibleChoices_(&pc)
	{}
	Choice ChooseFirstUnknown::getChoice()
	{
		assert(possibleChoices_);
		if(possibleChoices_->empty())
			throw NoChoiceLeft();

		return Choice(*possibleChoices_->begin(), true);
	}
	void ChooseFirstUnknown::reinitialize(const PossibleChoices& pc)
	{
		possibleChoices_ = &pc;
	}
	ChoicePolicy* ChooseFirstUnknown::create()
	{
		return new ChooseFirstUnknown();
	}
	ChoicePolicy* ChooseFirstUnknown::clone() const
	{
		return new ChooseFirstUnknown();
	}
	///////////////////////////////////////////////////////////
	// ChooseRandom
	///////////////////////////////////////////////////////////
	ChooseRandom::ChooseRandom()
		:	possibleChoices_(0)
		,	random_(static_cast<unsigned long>(PortableThreads::PTime().stamp()))
	{}
	ChooseRandom::ChooseRandom(const PossibleChoices& pc)
		:	possibleChoices_(&pc)
		,	random_(static_cast<unsigned long>(PortableThreads::PTime().stamp()))
	{}
	Choice ChooseRandom::getChoice()
	{
		assert(possibleChoices_);
		if(possibleChoices_->empty())
			throw NoChoiceLeft();
		
		size_t index = random_.urand() % possibleChoices_->size();
		PossibleChoices::const_iterator it = possibleChoices_->begin();
		advance(it, index);
		return Choice(*it, true);
	}
	void ChooseRandom::reinitialize(const PossibleChoices& pc)
	{
		possibleChoices_ = &pc;
	}
	ChoicePolicy* ChooseRandom::create()
	{
		return new ChooseRandom();
	}
	ChoicePolicy* ChooseRandom::clone() const
	{
		return new ChooseRandom();
	}
}
