/*	$Id: chooser.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PLATYPUS_CHOOSER_IMPL
#define PLATYPUS_CHOOSER_IMPL

#include <algorithm>
#include <portablethreads/utility.h>
#include <platypus/types/choice.h>

namespace Platypus
{
	class ChoicePolicy
	{
	public:
		virtual ~ChoicePolicy()
		{}
		virtual ChoicePolicy* clone() const = 0;
		virtual Choice getChoice() = 0;
		virtual void reinitialize(const PossibleChoices&) = 0;
	};

	const char* const CHOICE_POLICY_CHOOSE_FIRST = "choose-first";
	class ChooseFirstUnknown : public ChoicePolicy
	{
		const PossibleChoices* possibleChoices_;
	public:
		static ChoicePolicy* create();
		ChooseFirstUnknown();
		ChooseFirstUnknown(const PossibleChoices& pc);
		Choice getChoice();
		ChoicePolicy* clone() const;
		void reinitialize(const PossibleChoices& pc);
	};

	const char* const CHOICE_POLICY_CHOOSE_RANDOM = "random";
	class ChooseRandom : public ChoicePolicy
	{
	public:
		static ChoicePolicy* create();
		ChooseRandom();
		ChooseRandom(const PossibleChoices& pc);
		Choice getChoice();
		ChoicePolicy* clone() const;
		void reinitialize(const PossibleChoices& pc);
	private:
		const PossibleChoices* possibleChoices_;
		PortableThreads::PRandom random_;
		
	};
	const char* const CHOICE_POLICY_EXPANDER = "expander";
	struct ChooseExpander
	{
		static ChoicePolicy* create() { return 0; }
	};
}	

#endif
