/*	$Id: exceptions.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PLATYPUS_TYPES_EXCEPTIONS_H
#define PLATYPUS_TYPES_EXCEPTIONS_H

#include <stdexcept>
#include <string>

namespace Platypus
{
	class PlatypusException : public std::runtime_error
	{
	public:
		PlatypusException(const std::string& reason = std::string())
			:	std::runtime_error(reason)
		{};
	};
	
	// Indicates that an atom does not exist
	// within the logic program (interface Program)
	// has been passed to a method.
	class UnknownAtom : public PlatypusException
	{
	public:
		UnknownAtom(const std::string& reason = "This atom does not exist in the logic program")
			:	PlatypusException(reason)
		{}
	};
	
	
	// Indicates indicates an invalid choice 
	// (e.g. the atom already has a truth value)
	class InvalidChoice : public PlatypusException
	{
	public:
		InvalidChoice(const std::string& reason = "The choice is invalid.")
			:	PlatypusException(reason)
		{}
	};
	
	// Indicates that no further choices are available
	class NoChoiceLeft : public PlatypusException
	{
	public:
		NoChoiceLeft(const std::string& reason = "There are no more atoms left to choose.")
			:	PlatypusException(reason)
		{}
	};
	
	// Indicates the errornous invocation of a method 
	// that implies that a choice has been made.
	class NoChoiceMade : public PlatypusException
	{
	public:
		NoChoiceMade(const std::string& reason = "No choice has been made.")
			:	PlatypusException(reason)
		{}
	};
		
	// Indicates that an atom was passed to a method that 
	// does not yet have a truth value assigned in partial
	// model.
	class NoTruthValue : public PlatypusException
	{
	public:
		NoTruthValue(const std::string& reason = "No truth value has been assigned to the atom.")
			:	PlatypusException(reason)
		{}
	};

	// Indicates that the logic program feed contains malformated lines
	class ParseError : public PlatypusException
	{
	public:
		ParseError(const std::string& reason = "The logic program contains errors.")
			:	PlatypusException(reason)
		{}
	};

	class TypeError : public PlatypusException
	{
	public:
		TypeError(const std::string& reason = "Incompatible type")
			:	PlatypusException(reason)
		{}
	};
}

#endif
