/*	$Id: name_generator.cpp 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <algorithm>
#include <set>
#include <sstream>
#include <functional>
#include <platypus/types/name_generator.h>

using namespace std;

namespace
{
	struct FindById : public std::unary_function<std::pair<int, string>, bool>
	{
		int atom_;
		FindById(int atom)
			:	atom_(atom)
		{}
		inline bool operator()(const std::pair<int, string>& entry) const
		{
			return entry.first == atom_;
		}
	};

	const char* const PREFIX = "_invisible";
}

bool NameGenerator::addAtom(int atom)
{
	Atom2Name::iterator res = find_if(dictionary_.begin(), dictionary_.end(), FindById(atom));
	if(res == dictionary_.end())
	{
		dictionary_.push_back(Atom2Name::value_type(atom, string()));
		return true;
	}
	return false;
}
bool NameGenerator::setName(int atom, const std::string& name)
{
	Atom2Name::iterator res = find_if(dictionary_.begin(), dictionary_.end(), FindById(atom));
	if(res == dictionary_.end())
		return false;
	
	res->second = name;
	return true;
};
void NameGenerator::generate()
{
	// obtain atom names of atoms
	// that did have names in the logic
	// program
	set<string> names;
	for(Atom2Name::const_iterator it = dictionary_.begin();
		it != dictionary_.end();
		++it)
	 {
	 	if(!it->second.empty())
	 		names.insert(it->second);
	 }
	 
	 // generate names 
	 int counter = 0;
	 for(Atom2Name::iterator it = dictionary_.begin();
		it != dictionary_.end();
		++it)
	 {
	 	while(it->second.empty())
	 	{
	 		--counter;
	 		stringstream n;
	 		n << PREFIX << counter;
	 		if(!names.count(n.str()))
	 			it->second = n.str();
	 	}
		names.insert(it->second);
	 }
}

const std::string& NameGenerator::getName(int atom) const // throws NoName
{
	Atom2Name::const_iterator res = find_if(dictionary_.begin(), dictionary_.end(), FindById(atom));
	if(res == dictionary_.end())
		throw NoName();
	
	if(res->second.empty())
		throw NoName();
	return res->second;
}
