/*	$Id: parser.h 1728 2005-05-06 08:08:53Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef PARSER_H
#define PARSER_H

#include <iosfwd>
#include <string>
#include <set>
#include <stdexcept>

class LParser;
class LParserCallback
{
public:
	virtual ~LParserCallback() {}
	virtual void setup() {}
	virtual void addRuleLine(const std::string& line) = 0;
	virtual void addAtom(int atom) = 0;
	virtual void setName(int atom, const std::string& name) = 0;
	virtual void addBodyPlusLine(const std::string& line) = 0;
	virtual void addBodyMinusLine(const std::string& line) = 0;
	virtual void addNoModels(unsigned) = 0;
	virtual void done() {}
};

struct ParseError : std::runtime_error
{
	int line_;
	ParseError(const std::string& reason = "", int line = -1)
		:	std::runtime_error(reason)
		,	line_(line)
	{}
};

class LParser
{
	std::istream* input_;
	std::istream* data_;
	LParserCallback* callback_;

	typedef std::set<int> AtomSet;
	bool readBodyAtoms(std::istream& s, AtomSet& atoms, int noNegative, int noPositive);
	bool readBasicRule(std::string& line, AtomSet& atoms);
	bool readConstraintRule(std::string& line, AtomSet& atoms);
	bool readChoiceRule(std::string& line, AtomSet& atoms);
	bool readWeightRule(std::string& line, AtomSet& atoms);
	bool readMinimizeRule(std::string& line, AtomSet& atoms);
	bool readRule(std::string& line, AtomSet& atoms);
	bool readAtomName(std::string& line, AtomSet& atoms);
	bool readNoModels(std::string& line);
	bool addAtom(int atom, AtomSet& atoms);
public:
	~LParser();
	LParser();
	LParser(const std::string& input, LParserCallback* callback = 0);
	LParser(std::istream& input, LParserCallback* callback = 0);
	void setInput(const std::string& input);
	void setInput(std::istream& input);
	void setCallback(LParserCallback* callback);
	void parse();
};

#endif
