/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef X86_32_WIN32_COMMON_H
#define X86_32_WIN32_COMMON_H

#include <windows.h>
#include <portablethreads/arch/arch-common.h>

PT_NAMESPACE_BEGIN

// 32 Bit
inline int32 pt_atomic_add(volatile int32* counter, int32 value)
{
	return (int32) InterlockedExchangeAdd((LONG volatile*)counter, (LONG)value) + value;
}

inline int32 pt_atomic_sub(volatile int32* counter, int32 value)
{
	return pt_atomic_add(counter, -value);
}

inline int32 pt_atomic_inc(volatile int32* counter)
{
	return pt_atomic_add(counter, 1);
}

inline int32 pt_atomic_dec(volatile int32* counter)
{
	return pt_atomic_add(counter, -1);
}

/*
 * Atomic compare and exchange.  Compare OLD with MEM, if identical,
 * store NEW in MEM.  Return the initial value in MEM. Returns true if the
 * contents have been replaced.
 */
inline int32 pt_atomic_cas_return_memory(volatile int32* inMemory, int32 newValue, int32 oldValue)
{
	return (int32)InterlockedCompareExchange((LONG volatile*)inMemory, (LONG)newValue, (LONG)oldValue);
}

inline bool pt_atomic_cas(volatile int32* mem, int32 nv, int32 ov)
{
	return pt_atomic_cas_return_memory(mem, nv, ov) == ov;
}

inline int32 pt_atomic_set(volatile int32* inMemory, int32 newValue)
{
	return (int32)InterlockedExchange((LONG volatile*)inMemory, (LONG)newValue);
}

PT_NAMESPACE_END

#endif
