/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef X86_64_LINUX_GCC_H
#define X86_64_LINUX_GCC_H

PT_NAMESPACE_BEGIN
typedef signed char int8;
typedef unsigned char uint8;
typedef short int16;
typedef unsigned short uint16;
typedef int int32;
typedef unsigned int uint32;
typedef long int64;
typedef unsigned long uint64;

// Most of these functions are due to the Linux kernel.
inline void pt_barrier()
{
	__asm__ __volatile__("mfence": : :"memory");
}

inline int64 pt_atomic_add(volatile int64* counter, int64 value)
{
	const int64 res = value;
	__asm__ __volatile__(
		"lock xaddq %0, %1"
		:"=r"(value)
		:"m"(*counter), "0"(value)
	);
	return res + value;
}

inline int64 pt_atomic_sub(volatile int64* counter, int64 value)
{
	return pt_atomic_add(counter, -value);
}

inline int64 pt_atomic_inc(volatile int64* counter)
{
	return pt_atomic_add(counter, 1);
}

inline int64 pt_atomic_dec(volatile int64* counter)
{
	return pt_atomic_add(counter, -1);
}

/*
 * Atomic compare and exchange.  Compare OLD with MEM, if identical,
 * store NEW in MEM.  Return the initial value in MEM.  Success is
 * indicated by comparing RETURN with OLD.
 */
inline int64 pt_atomic_cas_return_memory(volatile int64* inMemory, int64 newValue, int64 oldValue)
{
	int64 prev;	
	__asm__ __volatile__(
		"lock cmpxchgq %1, %2"
		: "=a"(prev)
	    : "q"(newValue), "m"(*inMemory), "0"(oldValue)
	    : "memory"
	);
	return prev;
}

inline bool pt_atomic_cas(volatile int64* mem, int64 nv, int64 ov)
{
	return pt_atomic_cas_return_memory(mem, nv, ov) == ov;
}

inline int64 pt_atomic_set(volatile int64* inMemory, int64 newValue)
{
	__asm__ __volatile__(
		"xchgq %0, %1"
		:"=r" (newValue)
		:"m" (*inMemory), "0" (newValue)
		:"memory"
	);
	return newValue;
}

inline int64 pt_rol(int64 value, unsigned char shift = 1)
{
	__asm__ (
		"rolq %1, %0"
		:"=r"(value)
		:"c"(shift), "0"(value)
		:"cc"
	);
	return value;
}
inline int64 pt_ror(int64 value, unsigned char shift = 1)
{
	__asm__ (
		"rorq %1, %0"
		:"=r"(value)
		:"c"(shift), "0"(value)
		:"cc"
	);
	return value;
}


PT_NAMESPACE_END

#include <portablethreads/arch/arch-common.h>
#include <portablethreads/arch/manual-pointer-cas.h>

PT_NAMESPACE_BEGIN

// AMD64 & Intel's EM64T:
// Both currently use 48 bit for addressing. Hence we may
// safely use most significant 16 bits as well as the least significant 3 bits
// for reference counting. It is assumed that pointers only point to data alligned
// on at least 8 byte boundaries.
// 
// NOTE: Intel's EM64T cpus support cmpxchg16b, AMD's cpus not (yet).
typedef PTPrivate::PointerCAS<19> PTPointerCAS;

PT_NAMESPACE_END

#endif
