/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef COMMON_UTILITY_H
#define COMMON_UTILITY_H

PT_NAMESPACE_BEGIN
class PWaitable
{
public:
	virtual ~PWaitable() {}
	virtual bool queryState() = 0;
};

template<class T>
class PSingleWait;

// Helper the implements a guard
// To be used in functions that allow only one active thread at a time
// Assume "Lock" is a member of type PMutex of SomeClass
//
// bool SomeClass::is_empty()
// {
//		PMutexHelper<PMutex> dynunlock(Lock);
//		return SomeValue;
// }
//
// The mutex unlocks when the guards destructor is called
//   
template<class T> 
class PMutexHelper
{
	T& mutex_;
public:
	// Locks mutex on creation
 	PMutexHelper(T& mutex) : mutex_(mutex)
	{
		mutex_.lock();
	}
	
	// unlock mutex when going out of scope
	~PMutexHelper()
	{
		mutex_.unlock();
	}
};
PT_NAMESPACE_END

#endif
