/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef PT_MUTEX_H
#define PT_MUTEX_H
#include <portablethreads/config.h>
#ifdef WIN32
#	include <portablethreads/win32/mutex.h>
#endif
#ifdef UNIX
#	include <portablethreads/unix/mutex.h>
#endif

PT_NAMESPACE_BEGIN

class PNullMutex : public PWaitable
{
	
	PNullMutex(const PNullMutex&);
	PNullMutex& operator=(const PNullMutex&);
public:
	PNullMutex(bool locked = false)	
	{}
	inline bool tryLock() { return false; }
	inline void lock() {}
	inline void unlock() {}		
	bool queryState() { return false; }
};

template<>
class PSingleWait<PNullMutex>
{
	PSingleWait();
public:	
	PSingleWait(PNullMutex&)
	{}
	void wait() {}
};

template<>
class PSingleWait<PMutex>
{
	PMutex& waitFor_;
	PSingleWait();
public:	
	PSingleWait(PMutex& waitfor)
		:	waitFor_(waitfor)
	{}
	void wait()
	{
		waitFor_.lock();	
	}
};

template<>
class PSingleWait<PLightMutex>
{
	PLightMutex& waitFor_;
	PSingleWait();
public:	
	PSingleWait(PLightMutex& waitfor)
		:	waitFor_(waitfor)
	{}
	void wait()
	{
		waitFor_.lock();	
	}
};

template<>
class PMutexHelper<PNullMutex>
{
public:	
 	PMutexHelper(PNullMutex&) 
	{}	
};

PT_NAMESPACE_END

#endif
