/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef PT_SEMAPHORE_H
#define PT_SEMAPHORE_H
#include <portablethreads/config.h>
#ifdef WIN32
#	include <portablethreads/win32/semaphore.h>
#endif
#ifdef UNIX
#	include <portablethreads/unix/semaphore.h>
#endif

PT_NAMESPACE_BEGIN
class PNullSemaphore : public PWaitable
{
	PNullSemaphore(const PNullSemaphore&);
  	PNullSemaphore& operator=(const PNullSemaphore&);
public:	
	PNullSemaphore(unsigned int maxcount, unsigned int downCalls = 0)
	{}
  	
	inline bool tryDown() { return false; }
	inline void down() {}
	inline void up() {}  				
	inline bool queryState() { return false; }
};

template<>
class PMutexHelper<PNullSemaphore>
{
public:
	PMutexHelper(PNullSemaphore&) 	
	{}	
};

template<>
class PMutexHelper<PSemaphore>
{
	PSemaphore& sem_;
public:
	// Aquires one share of the semaphore on creation
 	PMutexHelper(PSemaphore& sem) 
		:	sem_(sem)
	{
		sem_.down();
	}
	
	// release our share when going out of scope
	~PMutexHelper()
	{
		sem_.up();
	}
};

template<>
class PSingleWait<PNullSemaphore>
{
	PSingleWait();
public:	
	PSingleWait(PNullSemaphore& waitfor)
	{}
	inline void wait() {}
};

template<>
class PSingleWait<PSemaphore>
{
	PSemaphore& waitFor_;
	PSingleWait();
public:	
	PSingleWait(PSemaphore& waitfor)
		:	waitFor_(waitfor)
	{}
	void wait()
	{
		waitFor_.down();	
	}
};

PT_NAMESPACE_END

#endif
