/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef UNIX_MUTEX_H
#define UNIX_MUTEX_H
#include <portablethreads/unix/config.h>

PT_NAMESPACE_BEGIN
class PMutex : public PWaitable
{
	pthread_mutex_t mutex_;
	
	void init(bool locked)
	{
		while(pthread_mutex_init(&mutex_, 0) < 0);		
		if(locked)
			lock();
	}
	PMutex(const PMutex& o);
	PMutex& operator=(const PMutex& o);
public:
	PMutex(bool locked = false) 		
	{
		init(locked);
	}
	
	~PMutex()
	{
		while(pthread_mutex_destroy(&mutex_) < 0);
	}
	inline bool tryLock() 
	{ 
		return pthread_mutex_trylock(&mutex_) == 0;		
	}
	inline void lock() 
	{ 
		while(pthread_mutex_lock(&mutex_) < 0); 
	}
	inline void unlock() 
	{ 
		while(pthread_mutex_unlock(&mutex_) < 0); 
	}		
	inline operator pthread_mutex_t*() { return &mutex_; }
	bool queryState() { return tryLock(); }
};

class PLightMutex : public PMutex
{
public:
	PLightMutex(bool locked = false) 		
		:	PMutex(locked)
	{}
};

PT_NAMESPACE_END

#endif
