/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef WIN32_THREAD_H
#define WIN32_THREAD_H

#include <portablethreads/win32/config.h>

#ifdef _MSC_VER
#	pragma warning(disable:4311) // pointer to integer
#endif 

PT_NAMESPACE_BEGIN
// see above
class PThread : public PThreadBase
{	
	HANDLE thread_;

	// Entry point for all threads 
	static DWORD WINAPI threadEntry(void* arg);

	// You need to subclass PThread an implement this method.
	// This will get called by the thread
	virtual void threadImpl() = 0;
	virtual void unexpectedException() throw();
	// Threads cannot be copied or assigned ;-)
	PThread(const PThread&);
	PThread& operator=(const PThread&);	
public:
	typedef unsigned long thread_type;
	static inline thread_type self()
	{
		return reinterpret_cast<thread_type>(GetCurrentThread());
	}
public:
	PThread()
		:	thread_(NULL)
  	{}
    
	virtual ~PThread();
	
	// Start the thread.
	// This method returns IMMEDIATELY, it does NOT wait until
	// the thread actually enters the ThreadImpl()-method
	inline bool run()
	{
		unsigned long temp; // Needed for Win9X
    	thread_ = CreateThread(0, 0, &threadEntry, this, 0, &temp);
    	return thread_ != NULL;
	}
	// Terminate (brute force) the thread. If the thread doesn't run this is a noop.
	// Do not use this method as a means to control you thread behavior. This is 
	// a last option method, because it may leave DLLs, file descriptors and the
	// like in an inconsistent state
	inline void stop()
	{
		TerminateThread(thread_, 0);		
	}
	// Wait for a thread to finish. This member function is only (portably) 
	// successfull if the thread wasn't detached using Detach()
	inline bool join()
	{
		if(joinable_)
			WaitForSingleObject(thread_, INFINITE);
		return joinable_;
	}
	// Give up the time slice that is left to a thread.
	inline void give()
	{
	 	Sleep(0);
	}		
	// Detaches a thread. This allows the thread library to reclaim resources
	// after the thread has finish. Each thread should either be detached 
	// or joined.
	inline void detach() { joinable_ = false; }		
	
	inline bool operator==(const PThread& o) const
	{
		if(&o == this)
			return true;
		
		return thread_ == o.thread_;	
	}
	
	inline bool operator!=(const PThread& o) const
	{
		return !(*this == o);
	}
	bool queryState() { return join(); }	
};	
PT_NAMESPACE_END

#ifdef _MSC_VER
#	pragma warning(disable:4311) // pointer to integer
#endif 

#endif
