#ifndef MY_CTPYE_H_INCLUDED
#define MY_CTPYE_H_INCLUDED
//	convenience interface for ctype functions
// 
//	ctype's functions parameters and return values are of type int.
//	But unless these ints are EOF, their value must be representable as an
//	unsigned char. 
//	Since char may or may not be signed, you have to cast a char to unsigned
//	char before calling a ctype function or else the function may yield 
//	unpredictable results.
// 
//	The functions defined in this header have easier interfaces.
//	Instead of taking and returning int, they all take a char and return bool.
//
//	

#include <ctype.h>

// wrappers for standard functions
inline bool	isAlphaNum(char c)
{
	return isalnum(static_cast<unsigned char>(c)) != 0;
}
inline bool	isAlpha(char c)
{
	return isalpha(static_cast<unsigned char>(c)) != 0;
}
inline bool	isControl(char c)
{
	return iscntrl(static_cast<unsigned char>(c)) != 0;
}
inline bool	isDigit(char c)
{
	return isdigit(static_cast<unsigned char>(c)) != 0;
}
inline bool	isGraph(char c)
{
	return isgraph(static_cast<unsigned char>(c)) != 0;
}
inline bool	isLower(char c)
{
	return islower(static_cast<unsigned char>(c)) != 0;
}
inline bool	isPrint(char c)
{
	return isprint(static_cast<unsigned char>(c)) != 0;
}
inline bool	isPunct(char c)
{
	return ispunct(static_cast<unsigned char>(c)) != 0;
}
inline bool	isSpace(char c)
{
	return isspace(static_cast<unsigned char>(c)) != 0;
}
inline bool	isUpper(char c)
{
	return isupper(static_cast<unsigned char>(c)) != 0;
}
inline bool	isHexDigit(char c)
{
	return isxdigit(static_cast<unsigned char>(c)) != 0;
}

inline char	toLower(char c)
{
	return tolower(static_cast<unsigned char>(c));

}
inline char	toUpper(char c)
{
	return toupper(static_cast<unsigned char>(c));
}

// extensions


// First character of C-Identifier: letter or underscore
inline bool isCSymFirst(char c)
{
	return isAlpha(c) || c == '_';
}

// C-Identifier: Letter, underscore, or digit
inline bool isCSym(char c)
{
	return isCSymFirst(c) || isDigit(c);
}

inline bool isOctDigit(char c)
{
	return isDigit(c) && c <= '7';
}

#endif
