// $Id: main.cpp 1683 2005-04-17 10:54:42Z jean $

#include <iostream>
#include <cstring>
#include <ctime>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/ui/text/TestRunner.h>
#include <cppunit/extensions/HelperMacros.h>

// CPPUNIT muss als statische lib gelinkt werden, sonst
// gibt es merkwrde "int 3" Fehler beim debuggen

using namespace std;

int main(int argc, char* argv[])
{
	unsigned count = 1;
	if(argc == 2)
	{
		if(strcmp(argv[1], "0") == 0)
		{
			count = (unsigned)-1;
		}
		else
		{
			count = atoi(argv[1]);
		}
	}
	
	CppUnit::TextUi::TestRunner runner;
	CppUnit::TestFactoryRegistry &registry = CppUnit::TestFactoryRegistry::getRegistry();
	runner.addTest( registry.makeTest() );
	
	const clock_t tv1 = clock();
	for(unsigned i = 0; i < count; ++i)
		runner.run();
	

	const clock_t tv2 = clock();
    const double time = tv2 / (CLOCKS_PER_SEC * 1.0) - tv1 / (CLOCKS_PER_SEC * 1.0);

	cout << "total time: " << time << endl;
	return 0;
}
