// $Id: program_metadata.cpp 1410 2004-08-01 11:37:51Z jean $

#include <iostream>
#include <sstream>
#include <algorithm>
#include <test/program_metadata.h>

using namespace std;

namespace
{
	std::istream& operator>>(std::istream& is, MetaData& metadata)
	{
		is	
			>> metadata.ruleLines_
			>> metadata.atoms_
			>> metadata.atomNames_
			>> metadata.bPlusLines_
			>> metadata.bMinusLines_
			>> metadata.models_
			>> metadata.answerSets_
			>> metadata.filename_;
		metadata.names_.clear();
		string name;
		while(is.good())
		{
			is >> name;
			metadata.names_.push_back(name);
		}
		std::sort(metadata.names_.begin(), metadata.names_.end());
		return is;
	}
}

bool MetaData::hasAtomName(const std::string& name) const
{
	return std::binary_search(names_.begin(), names_.end(), name);
}

ProgramMetaData::ProgramMetaData(std::istream& is)
{
	string line;
	while(getline(is, line))
	{
		if(line.empty() || line[0] == '#')
			continue;

		istringstream s(line);
		MetaData md;
		s >> md;
		if(!is.good() && !is.eof())
			throw MetaDataError("Input stream is bad!");
		if(md.filename_.empty())
			throw MetaDataError("Empty filename!");
		if((unsigned)md.atomNames_ != md.names_.size())
			throw MetaDataError("Number of names and number of actual names do not match");
		data_.insert(Name2Data::value_type(md.filename_, md));
	}
}
const MetaData& ProgramMetaData::get(const std::string& programname) const
{
	Name2Data::const_iterator res = data_.find(programname);
	if(res == data_.end())
		throw MetaDataError("There is no metadata available!");
	return res->second;
}
