// $Id: program_metadata.h 1410 2004-08-01 11:37:51Z jean $

#ifndef PROGRAM_METADATA_H
#define PROGRAM_METADATA_H

#include <map>
#include <string>
#include <iosfwd>
#include <stdexcept>
#include <vector>

struct MetaDataError : public std::runtime_error
{
	MetaDataError(const std::string& reason = "")
		:	std::runtime_error(reason)
	{}
};

struct MetaData
{
	typedef std::vector<std::string> Names;
	int ruleLines_;
	int atoms_;
	int atomNames_;
	int bPlusLines_;
	int bMinusLines_;
	int models_;
	int answerSets_;
	std::string filename_;
	Names names_;
	MetaData()
		:	ruleLines_(0)
		,	atoms_(0)
		,	atomNames_(0)
		,	bPlusLines_(0)
		,	bMinusLines_(0)
		,	models_(0)
		,	answerSets_(0)
		,	filename_()
	{}
	bool hasAtomName(const std::string& name) const;
};



class ProgramMetaData
{
	typedef std::map<std::string, MetaData> Name2Data;
	Name2Data data_;
	ProgramMetaData();
public:
	ProgramMetaData(std::istream& is);
	const MetaData& get(const std::string& programname) const;
};

#endif
