// $Id: test_partial_assignment.cpp 1679 2005-04-03 17:45:56Z jean $

#include <iostream>
#include <string>
#include <algorithm>
#include <fstream>
#include <functional>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <test/program_metadata.h>
#include <platypus/types.h>

using namespace std;
using namespace Platypus;

namespace
{
	struct FindByName : public std::unary_function<Platypus::Atom, bool>
	{
		typedef std::unary_function<Platypus::Atom, bool> Base;
		const std::string& name_;
		FindByName(const std::string& name)
			:	name_(name)
		{}
		inline bool operator()(const Atom& atom) const
		{
			return atom.name() == name_;
		}
	};
}

class PartialAssignmentTest : public CppUnit::TestFixture
{
	ProgramMetaData* metaData_;
	typedef ProgramInterface ProgramType;
	
public:
	PartialAssignmentTest()
	{
		ifstream in("metadata.txt");
		CPPUNIT_ASSERT(in);
		metaData_ = new ProgramMetaData(in);
	}
	~PartialAssignmentTest()
	{
		delete metaData_;
	}
	PartialAssignment getPartialAssignment(const char* filename, ProgramInterface& program)
	{
		ifstream in(filename);
		CPPUNIT_ASSERT(in);
		program.setup(in);
		
		return PartialAssignment(program);
	}
	void testCtor()
	{
		Program program;
		PartialAssignment pm(getPartialAssignment("usualcases.lparse", program));

		const MetaData& md = metaData_->get("usualcases.lparse");
		
		CPPUNIT_ASSERT_EQUAL(pm.hasUnknownAtoms(), true);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.positiveAtoms().size(), (size_t)0);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.negativeAtoms().size(), (size_t)0);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.unknownAtoms().size(), (size_t)md.atoms_);

	}

	void testSetTruthValue()
	{
		Program program;
		
		PartialAssignment pm(getPartialAssignment("usualcases.lparse", program));

		const MetaData& md = metaData_->get("usualcases.lparse");
		

		Atom p(*find_if(pm.unknownAtoms().begin(), pm.unknownAtoms().end(), FindByName("p")));
		pm.setFalse(p);

		Atom i(*find_if(pm.unknownAtoms().begin(), pm.unknownAtoms().end(), FindByName("i")));
		pm.setFalse(i);

		Atom h(*find_if(pm.unknownAtoms().begin(), pm.unknownAtoms().end(), FindByName("h")));
		pm.setTrue(h);
		
		CPPUNIT_ASSERT_EQUAL(pm.hasUnknownAtoms(), true);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.positiveAtoms().size(), (size_t)1);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.negativeAtoms().size(), (size_t)2);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.unknownAtoms().size(), (size_t)md.atoms_-3);

		pm.setTrue(i);
		pm.setFalse(h);

		pm.setUnknown(p);

		CPPUNIT_ASSERT_EQUAL(pm.hasUnknownAtoms(), true);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.positiveAtoms().size(), (size_t)1);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.negativeAtoms().size(), (size_t)1);
		CPPUNIT_ASSERT_EQUAL((size_t)pm.unknownAtoms().size(), (size_t)md.atoms_-2);		
	}
	
	CPPUNIT_TEST_SUITE( PartialAssignmentTest );
		CPPUNIT_TEST( testCtor );
		CPPUNIT_TEST( testSetTruthValue );
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( PartialAssignmentTest );


