// $Id: test_program.cpp 1679 2005-04-03 17:45:56Z jean $

#include <iostream>
#include <string>
#include <algorithm>
#include <fstream>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <test/program_metadata.h>
#include <platypus/types.h>

using namespace std;
using namespace Platypus;

class ProgramImplTest : public CppUnit::TestFixture
{
	ProgramMetaData* metaData_;
	typedef ProgramInterface ProgramType;
	void testFile(const char* filename)
	{
		CPPUNIT_ASSERT(filename);
		ifstream in(filename);
		CPPUNIT_ASSERT(in);

		Program program;
		program.setup(in);
		const MetaData& md = metaData_->get(filename);

		CPPUNIT_ASSERT_EQUAL((size_t)program.numberOfAtoms(), (size_t) md.atoms_);
		CPPUNIT_ASSERT_EQUAL((size_t)program.atoms().size(), (size_t) md.atoms_);

		for(ProgramType::CollectionType::const_iterator it = program.atoms().begin();
			it != program.atoms().begin(); ++it)
		{
			CPPUNIT_ASSERT(*it >= 1 && *it <= (unsigned)md.atoms_);
			if(program.hasDisplayName(*it))
			{
				CPPUNIT_ASSERT_EQUAL(md.hasAtomName(program.idToName(*it)), true); 
			}
			else
			{
				CPPUNIT_ASSERT_EQUAL(program.idToName(*it)[0], '_');
			}
		}
		// check lparse output (manually)
		if(0)
		{
			ofstream out((string("check_") + filename).c_str());
			CPPUNIT_ASSERT(out);
			out << program.lparse();
		}
	}
public:
	ProgramImplTest()
	{
		ifstream in("metadata.txt");
		CPPUNIT_ASSERT(in);
		metaData_ = new ProgramMetaData(in);
	}
	~ProgramImplTest()
	{
		delete metaData_;
	}
	void testCtor()
	{
		
		Program program;
		program.setup(EMPTY_PROGRAM);
		
		CPPUNIT_ASSERT_EQUAL((size_t)program.numberOfAtoms(), (size_t) 0);
		CPPUNIT_ASSERT_EQUAL((size_t)program.atoms().size(), (size_t) 0);
		CPPUNIT_ASSERT_EQUAL(program.lparse(), string(EMPTY_PROGRAM));

		try
		{
			program.idToName(0);
			CPPUNIT_ASSERT(false);
		}
		catch(UnknownAtom&)
		{}
		
		try
		{
			program.nameToId("foo");
			CPPUNIT_ASSERT(false);
		}
		catch(UnknownAtom&)
		{}

		try
		{
			program.hasDisplayName(2);
			CPPUNIT_ASSERT(false);
		}
		catch(UnknownAtom&)
		{}

	}

	void testUsualcases()
	{
		testFile("usualcases.lparse");
	}
	void testHamilton()
	{
		testFile("ham_comp_5.lparse");
	}
	void testColor()
	{
		testFile("color-3-4.lparse");
	}
	void testPigeon()
	{
		testFile("pigeon-3-4.lparse");
	}
	void testSchur()
	{
		testFile("schur-3-3.lparse");
	}
	void testQueens()
	{
		testFile("5queens.lparse");
	}
	
	CPPUNIT_TEST_SUITE( ProgramImplTest );
		CPPUNIT_TEST( testCtor );
		CPPUNIT_TEST( testUsualcases );
		CPPUNIT_TEST( testHamilton );	
		CPPUNIT_TEST( testColor );	
		CPPUNIT_TEST( testPigeon );	
		CPPUNIT_TEST( testSchur );
		CPPUNIT_TEST( testQueens );
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( ProgramImplTest );


