#include "uname.h"

#ifdef PT_HAVE_SUNOS

#include <sys/systeminfo.h>
#include <string>
#include <cassert>


using namespace std;
//long sysinfo(int command, char *buf, long count);

namespace
{
	string info(int cmd)
	{
		char buf[256];
		memset(buf, 0, sizeof(buf));
		sysinfo(cmd, buf, sizeof(buf));
		return string(buf);
	}

	string system()
	{
		return info(SI_SYSNAME);
	}

	string name()
	{
		return info(SI_HOSTNAME);
	}
	string release()
	{
		return info(SI_RELEASE);
	}

	string version()
	{
		return info(SI_VERSION);
	}
	string machine()
	{
		string arch(info(SI_MACHINE));
		arch += ' ';
		arch += info(SI_ARCHITECTURE);
		return arch;
	}

	const string PT_SYSTEM(system());
	const string PT_NAME(name());
	const string PT_RELEASE(release());
	const string PT_VERSION(version());
	const string PT_MACHINE(machine());
}

int uname(utsname* data)
{
	data->machine = PT_MACHINE.c_str();
	data->nodename = PT_NAME.c_str();
	data->release = PT_RELEASE.c_str();
	data->sysname = PT_SYSTEM.c_str();
	data->version = PT_VERSION.c_str();
	return 0;
}

#endif // HAVE_SUNOS

