/*	$Id: fork_serializer.h 1771 2005-05-16 12:00:38Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef FORK_SERIALIZER_H
#define FORK_SERIALIZER_H

#include <cassert>
#include <platypus/types_fwd.h>
#include <platypus/types/choice.h>
#include <distribution/fork/ipc.h>

namespace Platypus
{
	class ForkSerializer
	{
	public:
		ForkSerializer(const ProgramInterface& program);
		// returns the number of bytes required to send complete assignment
		size_t bytesRequired() const;
		void deserialize(DelegatableChoice& dc, const IPC::IPCMessageBuffer& buffer) const;
		void serialize(IPC::IPCMessageBuffer& buffer, const DelegatableChoice& dc) const;
		
		void deserialize(PartialAssignment& pa, const IPC::IPCMessageBuffer& buffer) const;
		void serialize(IPC::IPCMessageBuffer& buffer, const PartialAssignment& pa) const;
	private:
		ForkSerializer();
	private:
		const ProgramInterface* program_;
	};
}

#endif
