/*  Copyright (c) January 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef WIN32_CONDITION_H
#define WIN32_CONDITION_H
#include <portablethreads/win32/config.h>
#include <cassert>

PT_NAMESPACE_BEGIN
class PCondition
{
	HANDLE cond_;		
	
	// Conditions cannot be copied or assigned
	PCondition(const PCondition& o);
	PCondition& operator=(const PCondition& o);
public:
	// create a new nonsignaled condition
	PCondition() 
		:	cond_(CreateEvent(0, false, false, 0))
	{
		assert(cond_);
	}
	
	~PCondition()
	{
		CloseHandle(cond_);
	}
		
	// signal condition and wake up one thread
	inline void signal()
	{ 
		SetEvent(cond_);			
	}
	/*
	// signal condition and wake up all waiting threads		
	inline void broadcast()
	{ 
		signal();
	}
	*/
	// Wait for the condition to become signaled
	inline void wait()
	{
		while(WaitForSingleObject(cond_, INFINITE) != WAIT_OBJECT_0);			
	}
	
	// Wait a specified interval for the condition to become signaled
	inline bool wait(unsigned long sec, unsigned long nano)
	{
		return wait(sec*1000+nano/1000000);   			
	}
	
	inline bool wait(unsigned long milliseconds)
	{
		return WaitForSingleObject(cond_, milliseconds) == WAIT_OBJECT_0;   			
	}

	inline operator HANDLE() { return cond_; }
};
PT_NAMESPACE_END


#endif
