/*  Copyright (c) October 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef X_BYTE_POINTER_TO_INT_COMPRESSION_H
#define X_BYTE_POINTER_TO_INT_COMPRESSION_H

#ifndef PT_ARCH_COMMON_INCLUDED
#	error "Architectural types and functions must be included first!"
#endif 

#include <cassert>

namespace PortableThreads
{
	namespace LockFree
	{
		namespace Private
		{
			template<typename T, unsigned POINTER_BITS, unsigned HARDWARE_POINTER_BITS, unsigned ALIGNMENT_BITS>
			inline 
			typename ::PortableThreads::Private::PTSizeToType_<POINTER_BITS / 8>::int_type pt_inflate_pointer(T* p)
			{
				typedef typename ::PortableThreads::Private::PTSizeToType_<POINTER_BITS / 8>::int_type int_t;

				assert(HARDWARE_POINTER_BITS+2 <= POINTER_BITS); // shifting
				assert(ALIGNMENT_BITS < HARDWARE_POINTER_BITS);
				assert((POINTER_BITS % 8) == 0);
				assert(sizeof(int_t) >= sizeof(T*));
				assert((reinterpret_cast<int_t>(p) & ((static_cast<int_t>(1) << ALIGNMENT_BITS) - 1)) == static_cast<int_t>(0));

				return (
						(reinterpret_cast<int_t>(p) & (static_cast<int_t>(1) << HARDWARE_POINTER_BITS)) != static_cast<int_t>(0)
							? reinterpret_cast<int_t>(p) & ((static_cast<int_t>(1) << (HARDWARE_POINTER_BITS+1))-1)
							: reinterpret_cast<int_t>(p)
						) >> ALIGNMENT_BITS;	
			}

			template<typename T, unsigned POINTER_BITS, unsigned HARDWARE_POINTER_BITS, unsigned ALIGNMENT_BITS>
			inline 
			T* pt_deflate_pointer(typename ::PortableThreads::Private::PTSizeToType_<POINTER_BITS / 8>::int_type p)
			{
				typedef typename ::PortableThreads::Private::PTSizeToType_<POINTER_BITS / 8>::int_type int_t;

				return reinterpret_cast<T*>((
					(p & (static_cast<int_t>(1) << (HARDWARE_POINTER_BITS-ALIGNMENT_BITS))) != static_cast<int_t>(0)
						? p | (((static_cast<int_t>(1) << (POINTER_BITS-HARDWARE_POINTER_BITS+1))-1) << (HARDWARE_POINTER_BITS-ALIGNMENT_BITS))
						: p
					) << ALIGNMENT_BITS);	
			}
		}
	}
}

#endif
