#ifndef REGRESSION_TEST_H
#define REGRESSION_TEST_H

#include <istream>
#include <memory>
#include <sstream>
#include <string>
#include <stdexcept>
#include <platypus/types_fwd.h>
#include <regression/answer_sets.h>

class NopStream;
namespace Platypus
{
	class CoreBase;
}
namespace Regression
{
	const char* const TEST_FAILURE = "TEST FAILED";
	// exception thrown to terminate a process created during forking
	struct TestException : public std::runtime_error
	{
		TestException(const std::string& reason = "")
			:	std::runtime_error(reason)
		{}
	};

	struct TerminateProcess : public TestException
	{};

	template<class T>
	struct EqualityAssert
	{
		static void format(const char* file, unsigned line, const T& expected, const T& is)
		{
			if(expected != is)
			{
				std::ostringstream s;
				s << "Assertion FAILED!\n\t";
				s << "File " << file << ", line " << line << "\n\t";
				s << "Expected: " << expected << ", actual: " << is << "\n";
				throw TestException(s.str());			
			}			
		}
	};

	class AnswerSets;
	class AnswerSetChecker;
	class Test
	{
	public:
		~Test();
		Test(AnswerSets::AnswerSetsPtr as, const std::string& cmd, const std::string& name = std::string() );
		std::string getName () const;
		void runTest();
	private:
		std::auto_ptr<NopStream> stream_;
		AnswerSets::AnswerSetsPtr answerSets_;
		std::auto_ptr<AnswerSetChecker> checker_;		
		std::auto_ptr<Platypus::PlatypusOptions> options_;
		std::auto_ptr<Platypus::DistributionBase> distribution_;
		std::auto_ptr<Platypus::ProgramInterface> program_;
		std::auto_ptr<Platypus::CoreBase> core_;
		std::string name_, cmdl_;		
	};
}

#endif
