/*	$Id: delegatable_choice_policy.h 2709 2005-10-30 09:25:51Z jgressma $
 *
 *  Copyright 2005 University of Potsdam, Germany
 * 
 *	This file is part of Platypus.
 *
 *  Platypus is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Platypus is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Platypus; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef DELEGATABLE_CHOICE_POLICY_H
#define DELEGATABLE_CHOICE_POLICY_H

#include <deque>
#include <vector>
#include <portablethreads/random.h>
#include <platypus/types/choice.h>
#include <platypus/types/search_space.h>

namespace Platypus
{
	namespace DelegatableChoicePolicy
	{
		class PolicyBase
		{
		public:
			virtual ~PolicyBase()
			{}
			PolicyBase();
			virtual DelegatableChoice choose() = 0;
			void setup(SearchSpace& space);			
		protected:
			SearchSpace& searchSpace();
			const SearchSpace& searchSpace() const;
		private:
			SearchSpace* space_;
		};

		class Random : public PolicyBase
		{
		public:
			Random();
			DelegatableChoice choose();
			static PolicyBase* create();
		private:
			typedef SearchSpace::leaf_iterator iterator;
			std::vector<iterator> candidates_;
			PortableThreads::PTRandom rng_;
		};

		const char* const LARGEST_KEY = "largest";
		const char* const LARGEST_DESCRIPTION = "Delegate the largest part of the search space";
		class Largest : public PolicyBase
		{
		public:
			DelegatableChoice choose();
			static PolicyBase* create();
		private:
			std::deque<SearchSpace::cursor> toLookAt_;
		};

		const char* const SMALLEST_KEY = "smallest";
		const char* const SMALLEST_DESCRIPTION = "Delegate the smallest part of the search space";

		class Smallest : public PolicyBase
		{
		public:
			DelegatableChoice choose();
			static PolicyBase* create();
		private:
			typedef SearchSpace::leaf_iterator iterator;
			unsigned distance(iterator it) const;
		};
	}
};

#endif
