dnl Copyright (c) 2005 Jean Gressmann (jean@0x42.de)
dnl
dnl This file is distributed under the GNU Public License (GPL).
dnl Get a copy of the license at http://www.gnu.org/copyleft/gpl.html
dnl
dnl The content of this file is based on cppunit's cppunit.m4
dnl 



dnl The macro AM_PATH_DOXYGEN(version) takes as single parameter a
dnl the minimum required version of Doxygen (e.g.: 1.4.5). It sets the 
dnl variable DOXYGEN to the complete path of the Doxygen executable.
dnl If the required minimum version is not installed DOXYGEN is set
dnl to "no".

 AC_DEFUN([AM_PATH_DOXYGEN],
[
DOXYGEN=no
AC_ARG_WITH([doxygen], AS_HELP_STRING([--with-doxygen], [Path to doxygen if not in PATH]),
[
  if test -x "$withval/doxygen"
  then
    DOXYGEN="$withval/doxygen"
    AC_SUBST(DOXYGEN, [$withval/doxygen])
  fi
  AC_MSG_RESULT($DOXYGEN)
],
[
  AC_PATH_PROG(DOXYGEN, doxygen, no)  
])

  
  doxygen_version_min=$1

  AC_MSG_CHECKING(for Doxygen - version >= $doxygen_version_min)
  no_doxygen=""
  if test "$DOXYGEN" = "no" ; then
    no_doxygen=yes
  else
    
    doxygen_version=`$DOXYGEN --help | grep "Doxygen version" | sed s/"Doxygen version "// | cut -d- -f1`

    doxygen_major_version=`echo $doxygen_version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    doxygen_minor_version=`echo $doxygen_version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    doxygen_micro_version=`echo $doxygen_version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    doxygen_major_min=`echo $doxygen_version_min | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    doxygen_minor_min=`echo $doxygen_version_min | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    doxygen_micro_min=`echo $doxygen_version_min | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    doxygen_version_proper=`expr \
        $doxygen_major_version \> $doxygen_major_min \| \
        $doxygen_major_version \= $doxygen_major_min \& \
        $doxygen_minor_version \> $doxygen_minor_min \| \
        $doxygen_major_version \= $doxygen_major_min \& \
        $doxygen_minor_version \= $doxygen_minor_min \& \
        $doxygen_micro_version \>= $doxygen_micro_min `

    if test "$doxygen_version_proper" = "1" ; then
      AC_MSG_RESULT([$doxygen_major_version.$doxygen_minor_version.$doxygen_micro_version])
    else
      AC_MSG_RESULT(no)
      DOXYGEN=no
      no_doxygen=yes
    fi
  fi

  if test "x$no_doxygen" = x ; then
     ifelse([$2], , :, [$2])     
  else
     ifelse([$3], , :, [$3])
  fi

  
])

