#include <vector>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <portablethreads/thread.h>
#include <portablethreads/lockfree/heap.h>



using namespace std;
using namespace PortableThreads;
using namespace PortableThreads::LockFree;

namespace
{
	class ThreadSilentBase : public PThread
	{
		void unexpectedException() throw()
		{}
	};
	class ThreadBase : public ThreadSilentBase
	{
		void unexpectedException() throw()
		{
			CPPUNIT_ASSERT(false && "no exception excepted");
		}
	};
	class Thread0 : public ThreadBase
	{
	public:
		Thread0(volatile bool& flag, PTHeap& h, unsigned low, unsigned high)
			:	flag_(&flag)
			,	heap_(&h)
			,	low_(low)
			,	high_(high)
		{}	
	private:
		void threadMain()
		{
			while(!*flag_)
				give();

			vector<void*> v(high_ - low_);
			for(unsigned i = 0; i < high_ - low_; ++i)
			{
				v[i] = heap_->allocate(low_+i);
				CPPUNIT_ASSERT(v[i]);
				memset(v[i], i, low_+i);
				
			}

			for(unsigned i = 0; i < high_ - low_; ++i)
			{
				bool ok = true;
				for(unsigned j = 0; j < i+low_; ++j)
				{
					if(static_cast<char*>(v[i])[j] != (char)i)
					{
						ok = false;
						break;
					}
				}
				CPPUNIT_ASSERT(ok);
				heap_->deallocate(v[i]);

			}
		}
	private:
		volatile bool* flag_;
		PTHeap* heap_;
		unsigned low_, high_;
	};

}

class HeapTest : public CppUnit::TestFixture
{
public:
	void testDry()
	{
		PTHeap h;
		void* p = h.allocate(42);
		CPPUNIT_ASSERT(p);
		h.deallocate(p);

		p = h.allocate(0);
		CPPUNIT_ASSERT(p);
		h.deallocate(p);

		p = h.allocate(2000);
		CPPUNIT_ASSERT(p);
		h.deallocate(p);
	}
	void testBusy()
	{
		PTHeap h;
		volatile bool f = false;
		unsigned t = 4;
		unsigned low = 200;
		unsigned high = 600;
		vector<Thread0*> threads(t);

		CPPUNIT_ASSERT(low < high);
		for(unsigned i = 0; i < t; ++i)
		{
			threads[i] = new Thread0(f, h, low, high);
			threads[i]->run();
		}

		// start them off
		f = true;

		for(unsigned i = 0; i < t; ++i)
		{
			threads[i]->join();
			delete threads[i];
		}
	}
	CPPUNIT_TEST_SUITE( HeapTest );
		CPPUNIT_TEST( testDry );
		CPPUNIT_TEST( testBusy );
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( HeapTest );



