#include <iostream>
#include <fstream>
#include <cassert>
#include <stdexcept>
#include <memory>
#include <sstream>
#include <map>
#include <array_istream.h>
#include <regression/answer_sets.h>
#include <regression/test.h>
#include <regression/test_runner.h>
#include <regression/token_istream.h>
#include <regression/test_factory.h>

using namespace std;

namespace Regression
{
	typedef map<string, AnswerSets::AnswerSetsPtr> AnswerSetsDictionary;
	TestRunner* TestFactory::create(std::istream& input)
	{
		assert(input.good());

		AnswerSetsDictionary registeredAnswerSets;
		auto_ptr<TestRunner> suite(new TestRunner);

		string line;
		stringstream smodelsfilename, processedfilename, commandline, name;
		toolbox::array_istream str(0, 0);
		toolbox::token_istream tokens(str, '%');
		unsigned lineCount = 0;
		while(getline(input, line))
		{
			++lineCount;
			if(line.empty() || line[0] == '#')
				continue;

			str.set_array(line);
			str.clear();

			
			smodelsfilename.str("");
			smodelsfilename.clear();
			processedfilename.str("");
			processedfilename.clear();
			commandline.str("");
			commandline.clear();
			name.str("");
			name.clear();

			// answer set file%processed answer set file%command line%name
			tokens.clear();
			bool ok = tokens.scan();
			tokens >> smodelsfilename.rdbuf();
			tokens.clear();
			ok = ok && tokens.scan();
			tokens >> processedfilename.rdbuf();
			tokens.clear();
			ok = ok && tokens.scan();
			tokens >> commandline.rdbuf();
			tokens.clear();
			ok = ok && tokens.scan();
			tokens >> name.rdbuf();

			cout << "smodels output: " << smodelsfilename.str() << endl;
			cout << "processed answer sets: " << processedfilename.str() << endl;
			cout << "command line: " << commandline.str() << endl;
			cout << "name: " << name.str() << endl;
		
			if(!ok)
			{
				ostringstream os;
				os << "Incomplete line " << lineCount;
				throw std::runtime_error(os.str());
			}

			
			
			AnswerSetsDictionary::iterator res = registeredAnswerSets.find(smodelsfilename.str());
			if(res == registeredAnswerSets.end())
			{
				
				AnswerSets::AnswerSetsPtr as;
				ifstream is(processedfilename.str().c_str());
				if(!is)
				{
					ifstream is(smodelsfilename.str().c_str());
					if(!is)
					{
						ostringstream os;
						os << "Could not open smodels output file '" << smodelsfilename.str() << "' for reading";
						throw std::runtime_error(os.str());
					}
	
					as.reset(new AnswerSets(is, false));
					
					// if we have a file name to write preprocessed answer sets to...
					if(!processedfilename.str().empty())
					{
						ofstream os(processedfilename.str().c_str());
						if(!os)
						{
							ostringstream os;
							os << "Could not open processed answer set file '" << processedfilename.str() << "' for reading";
							throw std::runtime_error(os.str());						
						}
						as->store(os);
						if(!os)
						{
							ostringstream os;
							os << "Could not correctly write processed answer set file '" << processedfilename.str() << "' for reading";
							throw std::runtime_error(os.str());						
						}
					}
				}
				else
				{
					as.reset(new AnswerSets(is, true));
				}
				cout << "Creating new answer sets object for answer sets in '" << smodelsfilename.str() << "'" << endl;
				res = registeredAnswerSets.insert(make_pair(smodelsfilename.str(), as)).first;				
			}

			suite->addTest(new Test(res->second, commandline.str(), name.str()));	

		}
		return suite.release();
	}
}

