/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_LOOKAHEAD_HEURISTIC_H
#define LIBNOMORE_LOOKAHEAD_HEURISTIC_H

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <graph.h>
#include <head_node.h>
#include <body_node.h>
#include <operators/lookahead.h>
#include <cassert>
#include <algorithm>

namespace NS_NOMORE {

template <class HeuStrat>
class LookaheadHeuristic : public HeuStrat::BaseType {
public:
  //! the type of the heuristic value
  typedef typename HeuStrat::ValueType ValueType;

  //! the type of the binary predicate to be used for value comparisons
  typedef typename HeuStrat::ComparatorType ComparatorType;
  
  
  //! creates a new object
  /*! 
   * \param c A binary predicate used to compare two values of type ValueType
   * \param e An unary predicate used to valuate nodes.
   */
  LookaheadHeuristic(const ComparatorType& c = ComparatorType())
    : comparator_(c) {
  }
    
  /*!
   * registers this as handler for lookahead events.
   */
  void setGraph(Graph& g) {
    g.getEventManager().getChannelFor(event::Event<LookaheadExecution>()).connect(*this);
  }

  void handle(const LookaheadExecution& e) {
    if (e.state_ == ActivityState::started) {
      table_.clear();
    }
    else if (e.state_ == ActivityState::finished) {
      std::sort(table_.begin(), table_.end(), comparator_);
    }
  }
  //! overwrites the version declared in HeuStrat::BaseType
  void addHeuristicValue(Node* n, const ValueType& v) {
    table_.push_back(NodeValuePair(n, v));
  }

  
  Node* selectNode(const Constraint& c) {
    for (typename TableType::iterator it = table_.begin(); it != table_.end(); ++it) {
      if (c.isSatisfiedBy(*it->first))
        return it->first;
    }
    return 0;
  }
private:
  typedef std::pair<Node*, ValueType> NodeValuePair;
  typedef std::vector<NodeValuePair> TableType; 
  
  struct Cmp {
    Cmp(const ComparatorType& c)
      : cmp_(c)
    {}
    bool operator()(const NodeValuePair& p1, const NodeValuePair& p2) const {
      return cmp_(p1.second, p2.second);
    }
    ComparatorType cmp_;
  } comparator_;
  
  TableType table_;
};

}
#endif
