/*  Copyright (c) September 2005 Jean Gressmann (jsg@rz.uni-potsdam.de)
 *
 *  This is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version. 
 * 
 *	This file is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this file; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SPARC_32_V8_GCC_H
#define SPARC_32_V8_GCC_H

#ifndef __GNUC__
#	error "You must use a GNU C++ compatible compiler in order to use this header file!"
#endif

#include <sys/time.h>
#include <portablethreads/arch/32-gcc.h

namespace PortableThreads 
{
	// Assembler functions are straight from the linux kernel
	// NOTE: Appearently the pre v8plus architectures don't have 
	// even have simple cas (not to mention dcas)
	// SPARC is a 32-bit CPU with 32-bit addressing!

	namespace LockFree
	{
		namespace Private
		{
			inline int32 pt_atomic_set(volatile int32* mem, int32 val)
			{
				__asm__ __volatile__
				(
					"swap [%2], %0 \n\t"
					: "=&r" (val)
					: "0" (val), "r" (mem)
					: "memory"
				);
				return val;
			}

			inline bool pt_atomic_set_lock(volatile uint8* lock)
			{
				uint32 result;
				__asm__ __volatile__
				(
					"ldstub [%1], %0 \n\t"
					: "=r" (result)
					: "r" (lock)
					: "memory"
				);
				return result == 0;
			}

			inline void pt_atomic_clear_lock(volatile uint8* lock)
			{
				__asm__ __volatile__("stb %%g0, [%0] \n\t" : : "r"(lock) : "memory");
			}

			inline void pt_barrier()
			{
				__asm__ __volatile__("" : : : "memory");
			}

			const unsigned HARDWARE_POINTER_BITS = 32;
			const unsigned ALIGNMENT_BITS = 2;
		}
	}

	// No tick counter support on Sparc 8
	inline uint64 pt_seed()
	{
		timeval tv;
		gettimeofday(&tv, 0);
		
		uint64 t = tv.tv_usec;
		t += tv.tv_sec*1000000;
		return t;
	}
}

#include <portablethreads/arch/arch-common.h>
#include <portablethreads/arch/spinlock-pointer-cas.h>
#include <portablethreads/arch/spinlock-atomic-number.h>
#include <portablethreads/arch/free-high-bits-muxer.h>

namespace PortableThreads
{
	namespace LockFree
	{
		namespace Private
		{
			template<unsigned USER_BITS>
			struct PTPointerCASType
			{
				typedef PointerCAS< FreeHighBitsMuxer<int64, 64, 32, 2, USER_BITS> > PTPointerCAS;
			};

			typedef PTPointerCASType<0>::PTPointerCAS PTPointerCAS;
		}
	}
}

#endif
