#ifndef WIN32_XPLIB_H
#define WIN32_XPLIB_H

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#undef WIN32_LEAN_AND_MEAN
#include <string>

const char* const XPLIB_DLL_EXTENSION = ".dll";
class XPDLLLinker
{
public:
	~XPDLLLinker()
	{
		if(lib_)
			FreeLibrary(lib_);
	}
	XPDLLLinker(const std::string& name, bool completepath = false)
		:	lib_(completepath ? LoadLibrary(name.c_str()) : LoadLibrary((name + XPLIB_DLL_EXTENSION).c_str()))
	{
		if(lib_ == NULL)
		{
			LPVOID lpMsgBuf;
			if (!FormatMessage(	FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
			    				NULL,
			    				GetLastError(),
			   					MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
			   					(LPTSTR) &lpMsgBuf,
							    0,
							    NULL ))
			{
				throw XPDLLException("Could not load library '" + name + "'");
			}
			const std::string temp((char*)lpMsgBuf);
			
			// Free the buffer.
			LocalFree( lpMsgBuf );

			throw XPDLLException(temp);
		}
	}
	inline FARPROC reference(const std::string& name) const
	{
		return GetProcAddress(lib_, name.c_str());
	}
	inline operator HMODULE() const { return lib_; }
	inline HMODULE release() 
	{
		HMODULE temp = lib_; 
		lib_ = 0; 
		return temp;
	}
private:
	XPDLLLinker();
	XPDLLLinker(const XPDLLLinker&);
	XPDLLLinker& operator=(const XPDLLLinker&);
private:
	HMODULE lib_;
};


template<class T>
class XPFunctionProxy
{
public:
	XPFunctionProxy(FARPROC f = 0)
		:	function_((T)f)
	{}
	inline T function() const { return function_; }
	inline operator T() const { return  function_; }
	inline bool good() const { return function_ != 0; }
private:
	T function_;
};

#endif
