/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif
#include <operators/sequence.h>
#include <cassert>
namespace NS_NOMORE {

namespace {
  typedef std::vector<std::pair<Operator*,bool> > Ops;
  std::string makeName(const Ops& ops, bool closure) {
    std::string r = "(";
    for (Ops::size_type i = 0; i != ops.size(); ++i) {
      r += ops[i].first->getName();
      if (i < ops.size() - 1)
        r += ',';
    }
    r += closure ? ")*" : ")";
    return r;
  }
}

Sequence::Sequence(bool closure)
  : Operator(makeName(Operators(), closure))
	, closure_(closure) {
}

Sequence::Sequence(Operator* o1, Operator* o2, bool closure)
  : Operator(makeName(Operators(), closure))
	, closure_(closure) {
  add(o1);
  add(o2);
  setName(makeName(ops_, closure));
}


Sequence::~Sequence() {
  for (Operators::size_type i = 0; i != ops_.size(); ++i)
    if (ops_[i].second)
      delete ops_[i].first;
}

bool Sequence::execute() {
	
  bool result = false;
	do {
		result = false;
    for (std::vector<Operator*>::size_type i = 0; i != ops_.size(); ++i) {
      result |= (*ops_[i].first)();
    }
	} while (closure_ && result);
	return result;
}

void Sequence::setClosure(bool b) {
	closure_ = b;
  std::string n = getName();
  if (closure_ && *n.rbegin() != '*') {
    n += '*';
    setName(n);
  }
  else if (!closure_ && *n.rbegin() == '*') {
    n.erase(n.size() - 1);
    setName(n);
  }
}

void Sequence::add(Operator* o) {
  assert(o);
  ops_.push_back(OpInfo(o, true));
  setName(makeName(ops_, closure_));
}

void Sequence::add(Operator& o) {
  ops_.push_back(OpInfo(&o, false));
  setName(makeName(ops_, closure_));
}

void Sequence::add(Operator* o, bool takeOverOwnership) {
  if (takeOverOwnership)
    add(o);
  else
    add(*o);
}

Operator* Sequence::extractOperator(const std::string& name) {
  for (std::vector<Operator*>::size_type i = 0; i != ops_.size(); ++i) {
    if (Operator* op = ops_[i].first->extractOperator(name))
      return op;
  }
  return 0;
}

bool Sequence::validate(const OpSet& ops) const {
  for (std::vector<Operator*>::size_type i = 0; i != ops_.size(); ++i) {
    if (!ops_[i].first->validate(ops))
      return false;
  }
  return true;
}



}
