#include <vector>
#include <cppunit/TestCase.h>
#include <cppunit/TestCaller.h>
#include <cppunit/TestResult.h>
#include <cppunit/TestSuite.h>
#include <cppunit/extensions/HelperMacros.h>
#include <portablethreads/thread.h>
#include <portablethreads/lockfree/atomic_number.h>



using namespace std;
using namespace PortableThreads;
using namespace PortableThreads::LockFree;

namespace
{
	class ThreadSilentBase : public PThread
	{
		void unexpectedException() throw()
		{}
	};
	class ThreadBase : public ThreadSilentBase
	{
		void unexpectedException() throw()
		{
			CPPUNIT_ASSERT(false && "no exception excepted");
		}
	};
	
	class Thread0 : public ThreadBase
	{
	public:
		Thread0(volatile bool& flag, PTAtomicNumber& n, unsigned count)
			:	number_(&n)
			,	count_(count)
			,	flag_(&flag)
		{}
	private:
		void threadMain()
		{
			while(!*flag_)
				give();
			for(unsigned i = 0; i < count_; ++i)
			{
				if(i % 2)
					number_->inc(i);
				else
					number_->dec(i);
			}

			for(unsigned i = 0; i < count_; ++i)
			{
				if(i % 2)
					number_->dec(i);
				else
					number_->inc(i);
			}
		}
	private:
		PTAtomicNumber* number_;
		unsigned count_;
		volatile bool* flag_;
	};
}

class AtomicNumberTest : public CppUnit::TestFixture
{
public:
	typedef PTAtomicNumber::int_type int_type;
	void testDry()
	{
		PTAtomicNumber a1(0), a2(42);
		
		CPPUNIT_ASSERT_EQUAL(static_cast<int_type>(0), a1.get());
		CPPUNIT_ASSERT_EQUAL(static_cast<int_type>(42), a2.get());
		
		CPPUNIT_ASSERT_EQUAL(static_cast<int_type>(42), a1.inc(42));
		CPPUNIT_ASSERT_EQUAL(static_cast<int_type>(-1), a2.dec(43));

		CPPUNIT_ASSERT_EQUAL(static_cast<int_type>(43), ++a1);
		CPPUNIT_ASSERT_EQUAL(static_cast<int_type>(-1), a2++);

		CPPUNIT_ASSERT_EQUAL(static_cast<int_type>(42), --a1);
		CPPUNIT_ASSERT_EQUAL(static_cast<int_type>(0), a2--);

		a1 -= 42;
		a2 += 43;
		CPPUNIT_ASSERT_EQUAL(static_cast<int_type>(0), a1.get());
		CPPUNIT_ASSERT_EQUAL(static_cast<int_type>(42), a2.get());


		CPPUNIT_ASSERT_EQUAL(false, a1.cas(0, 42));
		CPPUNIT_ASSERT_EQUAL(true, a2.cas(0, 42));

		a1 = -1;
		a2 = -1;

		CPPUNIT_ASSERT_EQUAL(static_cast<int_type>(-1), a1.get());
		CPPUNIT_ASSERT_EQUAL(static_cast<int_type>(-1), a2.get());
	}
	void testBusy()
	{
		volatile bool flag = false;
		PTAtomicNumber n;
		const unsigned t = 8;
		const unsigned count = 1000;
		vector<Thread0*> threads(t);
		for(unsigned i = 0; i < t; ++i)
		{
			threads[i] = new Thread0(flag, n, count);
			threads[i]->run();
		}

		// off they go...
		CPPUNIT_ASSERT_EQUAL(static_cast<int_type>(0), n.get());
		flag = true;

		for(unsigned i = 0; i < t; ++i)
		{
			threads[i]->join();
			delete threads[i];
		}

		CPPUNIT_ASSERT_EQUAL(static_cast<int_type>(0), n.get());
	}
	CPPUNIT_TEST_SUITE( AtomicNumberTest );
		CPPUNIT_TEST( testDry );
		CPPUNIT_TEST( testBusy );
	CPPUNIT_TEST_SUITE_END();
};


CPPUNIT_TEST_SUITE_REGISTRATION( AtomicNumberTest );



