#include <cassert>
#include <cstring>
#include <array_istream.h>
#include <regression/command_line.h>

using namespace std;

namespace Regression
{
	CommandLine::CommandLine(int argc, char** argv)
		:	commandLine_(argc)
		,	argv_(argc + 1, static_cast<char*>(0))
		,	argc_(argc)
	{
		assert(argc >= 0);
		for(int i = 0; i < argc; ++i)
		{
			commandLine_[i].assign(argv[i], argv[i] + strlen(argv[i]) + 1);
			argv_[i] = &commandLine_[i][0];
		}
	}
	CommandLine::CommandLine(const std::string& cmdl)
		:	argc_(0)
	{
		toolbox::array_istream input(cmdl);
		for(string temp; input >> temp; )
		{
			++argc_;
			commandLine_.push_back(std::vector<char>());
			commandLine_.back().assign(temp.begin(), temp.end());
			commandLine_.back().push_back('\0');
		}
		argv_.resize(argc_+1, static_cast<char*>(0));
		for(int i = 0; i < argc_; ++i)
			argv_[i] = &commandLine_[i][0];
	}
	int& CommandLine::argc()
	{
		return argc_;
	}
	char** CommandLine::argv()
	{
		return &argv_[0];
	}
}

