#include <cassert>
#include <iostream>
#include <portablethreads/config.h>

using namespace std;
using namespace PortableThreads;
using namespace PortableThreads::LockFree::Private;

void testSetAndClearLock()
{
	volatile uint8 lock = 0;
	
	pt_atomic_clear_lock(&lock);
	assert(lock == 0);

	assert(pt_atomic_set_lock(&lock));
	assert(!pt_atomic_set_lock(&lock));


	pt_atomic_clear_lock(&lock);
	assert(lock == 0);
	pt_atomic_clear_lock(&lock);
	assert(lock == 0);
}
#ifdef PT_HAVE_CAS
void testCas()
{
	volatile pt_int_type i = 0;

	assert(pt_atomic_cas(&i, 42, 0));
	assert(i == 42);
	assert(!pt_atomic_cas(&i, 42, 0));
	assert(i == 42);
	assert(pt_atomic_cas(&i, -3, 42));
	assert(i == -3);
}
void testArithmetic()
{
	volatile pt_int_type i = 0;

	pt_atomic_add(&i, 42);
	assert(i == 42);

	pt_atomic_add(&i, -42);
	assert(i == 0);

	pt_atomic_sub(&i, 23);
	assert(i == -23);

	pt_atomic_sub(&i, -23);
	assert(i == 0);

	pt_atomic_inc(&i);
	pt_atomic_inc(&i);
	pt_atomic_inc(&i);

	assert(i == 3);

	pt_atomic_dec(&i);
	assert(i == 2);
}
#endif
#ifdef PT_HAVE_CAS2
void testCas2()
{
	typedef Private::PTSizeToType<2*sizeof(pt_int_type)>::int_type large_int_type;
	volatile large_int_type i = 0xffffffff;
	i <<= 16;
	volatile large_int_type check = i;
	i = 0;

	assert(pt_atomic_cas(&i, check, 0));
	assert(check == i);
	assert(!pt_atomic_cas(&i, check, 0));
	assert(check == i);
	assert(pt_atomic_cas(&i, ~check, check));
	check = ~check;
	assert(check == i);
}
#endif

using namespace std;

int main()
{
	char* foo = new char[100000];
	cout << "Pointer: " << static_cast<void*>(foo) << ", sizeof(void*): " << sizeof(void*) << endl;
	delete [] foo;
	testSetAndClearLock();
#ifdef PT_HAVE_CAS
	testCas();
	testArithmetic();
#endif
#ifdef PT_HAVE_CAS2
	testCas2();
#endif

	cout << "OK!" << endl;
	return 0;
}




