#include <distribution/mpi/mpi_control_model_handler.h>

namespace Platypus
{
  
  MPIControlModelHandler::MPIControlModelHandler()
    :   indices_(0)
    ,   requested_(0)
    ,   localModels_(0)
    ,   globalModels_(0)
  {}

  MPIControlModelHandler::~MPIControlModelHandler()
  {}
  
  void MPIControlModelHandler::setup(unsigned indices, unsigned requested)
  {
    indices_ = indices;
    requested_ = requested;
    models_.resize(indices_, 0);
  }

  void MPIControlModelHandler::incLocalModels(unsigned inc)
  {
    localModels_ += inc;
  }

  void MPIControlModelHandler::setGlobalModels(unsigned index, unsigned inc)
  {
    unsigned temp = models_.at(index);
    models_.at(index) = inc;
    globalModels_ -= temp;
    globalModels_ += inc;
  }

  unsigned MPIControlModelHandler::localModels() const
  {
    return localModels_;
  }

  unsigned MPIControlModelHandler::globalModels() const
  {
    return globalModels_;
  }

  unsigned MPIControlModelHandler::indexGlobalModels(unsigned index) const
  {
    return models_.at(index);
  }

  bool MPIControlModelHandler::enough() const
  {
    if(requested_)
      return localModels_ == requested_;
    return false;
  }
  
}
