#ifndef MPI_CONTROL_MODEL_HANDLER_H
#define MPI_CONTROL_MODEL_HANDLER_H

#include <vector>

namespace Platypus
{

  class MPIControlModelHandler
  {
  public:

    MPIControlModelHandler();
    ~MPIControlModelHandler();

    void setup(unsigned indices, unsigned requested);
    void incLocalModels(unsigned inc = 1);
    void setGlobalModels(unsigned index, unsigned inc = 1);
    unsigned localModels() const;
    unsigned globalModels() const;
    unsigned indexGlobalModels(unsigned index) const;
    bool enough() const;

  private:

    unsigned indices_;
    unsigned requested_;
    unsigned localModels_;
    unsigned globalModels_;

    std::vector<unsigned> models_;

  };

}

#endif
